/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.Bundle;
import org.netbeans.modules.php.analysis.commands.CodeSniffer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.results.Result;
import org.netbeans.modules.php.analysis.ui.analyzer.CodeSnifferCustomizerPanel;
import org.netbeans.modules.php.analysis.util.AnalysisUtils;
import org.netbeans.modules.php.analysis.util.Mappers;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

public class CodeSnifferAnalyzerImpl
implements Analyzer {
    private static final Logger LOGGER = Logger.getLogger(CodeSnifferAnalyzerImpl.class.getName());
    private final Analyzer.Context context;
    private final AtomicBoolean cancelled = new AtomicBoolean();

    CodeSnifferAnalyzerImpl(Analyzer.Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends ErrorDescription> analyze() {
        Preferences settings = this.context.getSettings();
        if (settings != null && !settings.getBoolean("codeSniffer.enabled", false)) {
            return Collections.emptyList();
        }
        CodeSniffer codeSniffer = this.getValidCodeSniffer();
        if (codeSniffer == null) {
            this.context.reportAnalysisProblem(Bundle.CodeSnifferAnalyzerImpl_codeSniffer_error(), (CharSequence)Bundle.CodeSnifferAnalyzerImpl_codeSniffer_error_description());
            return Collections.emptyList();
        }
        String codeSnifferStandard = this.getValidCodeSnifferStandard();
        if (codeSnifferStandard == null) {
            this.context.reportAnalysisProblem(Bundle.CodeSnifferAnalyzerImpl_codeSniffer_standard_error(), (CharSequence)Bundle.CodeSnifferAnalyzerImpl_codeSniffer_standard_error_description());
            return Collections.emptyList();
        }
        Scope scope = this.context.getScope();
        Map<FileObject, Integer> fileCount = AnalysisUtils.countPhpFiles(scope);
        int totalCount = 0;
        for (Integer count : fileCount.values()) {
            totalCount += count.intValue();
        }
        this.context.start(totalCount);
        try {
            Iterable<? extends ErrorDescription> iterable = this.doAnalyze(scope, codeSniffer, codeSnifferStandard, fileCount);
            return iterable;
        }
        finally {
            this.context.finish();
        }
    }

    public boolean cancel() {
        this.cancelled.set(true);
        return true;
    }

    private Iterable<? extends ErrorDescription> doAnalyze(Scope scope, CodeSniffer codeSniffer, String codeSnifferStandard, Map<FileObject, Integer> fileCount) {
        List<Result> results;
        ArrayList<Object> errors = new ArrayList<Object>();
        int progress = 0;
        codeSniffer.startAnalyzeGroup();
        for (FileObject root : scope.getSourceRoots()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = codeSniffer.analyze(codeSnifferStandard, root);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.CodeSnifferAnalyzerImpl_analyze_error(), (CharSequence)Bundle.CodeSnifferAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(root).intValue());
        }
        for (FileObject file : scope.getFiles()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            results = codeSniffer.analyze(codeSnifferStandard, file);
            if (results == null) {
                this.context.reportAnalysisProblem(Bundle.CodeSnifferAnalyzerImpl_analyze_error(), (CharSequence)Bundle.CodeSnifferAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results));
            this.context.progress(progress += fileCount.get(file).intValue());
        }
        for (NonRecursiveFolder nonRecursiveFolder : scope.getFolders()) {
            if (this.cancelled.get()) {
                return Collections.emptyList();
            }
            FileObject folder = nonRecursiveFolder.getFolder();
            List<Result> results2 = codeSniffer.analyze(codeSnifferStandard, folder, true);
            if (results2 == null) {
                this.context.reportAnalysisProblem(Bundle.CodeSnifferAnalyzerImpl_analyze_error(), (CharSequence)Bundle.CodeSnifferAnalyzerImpl_analyze_error_description());
                return Collections.emptyList();
            }
            errors.addAll(Mappers.map(results2));
            this.context.progress(progress += fileCount.get(folder).intValue());
        }
        return errors;
    }

    @CheckForNull
    private CodeSniffer getValidCodeSniffer() {
        try {
            return CodeSniffer.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    @CheckForNull
    private String getValidCodeSnifferStandard() {
        ValidationResult result;
        String codeSnifferStandard = null;
        Preferences settings = this.context.getSettings();
        if (settings != null) {
            codeSnifferStandard = settings.get("codeSniffer.standard", null);
        }
        if (codeSnifferStandard == null) {
            codeSnifferStandard = AnalysisOptions.getInstance().getCodeSnifferStandard();
        }
        if ((result = new AnalysisOptionsValidator().validateCodeSnifferStandard(codeSnifferStandard).getResult()).hasErrors() || result.hasWarnings()) {
            return null;
        }
        assert (codeSnifferStandard != null);
        return codeSnifferStandard;
    }

    public static final class CodeSnifferAnalyzerFactory
    extends Analyzer.AnalyzerFactory {
        private static final String ICON_PATH = "org/netbeans/modules/php/analysis/ui/resources/code-sniffer.png";

        public CodeSnifferAnalyzerFactory() {
            super("PhpCodeSniffer", Bundle.CodeSnifferAnalyzerFactory_displayName(), ICON_PATH);
        }

        public Iterable<? extends Analyzer.WarningDescription> getWarnings() {
            return Collections.emptyList();
        }

        public Analyzer.CustomizerProvider<Void, CodeSnifferCustomizerPanel> getCustomizerProvider() {
            return new Analyzer.CustomizerProvider<Void, CodeSnifferCustomizerPanel>(){

                public Void initialize() {
                    return null;
                }

                public CodeSnifferCustomizerPanel createComponent(Analyzer.CustomizerContext<Void, CodeSnifferCustomizerPanel> context) {
                    return new CodeSnifferCustomizerPanel(context);
                }
            };
        }

        public Analyzer createAnalyzer(Analyzer.Context context) {
            return new CodeSnifferAnalyzerImpl(context);
        }

        public void warningOpened(ErrorDescription warning) {
            HintsController.setErrors((FileObject)warning.getFile(), (String)"phpCodeSnifferWarning", Collections.singleton(warning));
        }
    }
}

