/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.php.analysis.commands.MessDetector;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.ui.MessDetectorRuleSetsListModel;
import org.netbeans.modules.php.analysis.ui.options.AnalysisCategoryPanel;
import org.netbeans.modules.php.analysis.ui.options.Bundle;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MessDetectorOptionsPanel
extends AnalysisCategoryPanel {
    private static final long serialVersionUID = -2710584730175872452L;
    private static final String MESS_DETECTOR_LAST_FOLDER_SUFFIX = ".messDetector";
    private final MessDetectorRuleSetsListModel ruleSetsListModel = new MessDetectorRuleSetsListModel();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton messDetectorBrowseButton;
    private JLabel messDetectorHintLabel;
    private JLabel messDetectorLabel;
    private JLabel messDetectorLearnMoreLabel;
    private JLabel messDetectorRuleSetsLabel;
    private JList<String> messDetectorRuleSetsList;
    private JScrollPane messDetectorRuleSetsScrollPane;
    private JButton messDetectorSearchButton;
    private JTextField messDetectorTextField;
    private JLabel minVersionInfoLabel;
    private JLabel noteLabel;

    public MessDetectorOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.initMessDetector(defaultDocumentListener);
    }

    private void initMessDetector(DocumentListener defaultDocumentListener) {
        this.messDetectorHintLabel.setText(Bundle.MessDetectorOptionsPanel_hint("phpmd", MessDetector.LONG_NAME));
        this.messDetectorTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.messDetectorRuleSetsList.addListSelectionListener(new DefaultListSelectionListener());
        this.messDetectorRuleSetsList.setModel(this.ruleSetsListModel);
    }

    public String getMessDetectorPath() {
        return this.messDetectorTextField.getText();
    }

    public void setMessDetectorPath(String path) {
        this.messDetectorTextField.setText(path);
    }

    public List<String> getMessDetectorRuleSets() {
        return this.getSelectedRuleSets();
    }

    public void setMessDetectorRuleSets(List<String> ruleSets) {
        this.selectRuleSets(ruleSets);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    List<String> getSelectedRuleSets() {
        return this.messDetectorRuleSetsList.getSelectedValuesList();
    }

    void selectRuleSets(List<String> ruleSets) {
        this.messDetectorRuleSetsList.clearSelection();
        for (String ruleSet : ruleSets) {
            int indexOf = MessDetectorRuleSetsListModel.getAllRuleSets().indexOf(ruleSet);
            assert (indexOf != -1) : "Rule set not found: " + ruleSet;
            this.messDetectorRuleSetsList.addSelectionInterval(indexOf, indexOf);
        }
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    @Override
    public String getCategoryName() {
        return Bundle.MessDetectorOptionsPanel_category_name();
    }

    @Override
    public void update() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        this.setMessDetectorPath(analysisOptions.getMessDetectorPath());
        this.setMessDetectorRuleSets(analysisOptions.getMessDetectorRuleSets());
    }

    @Override
    public void applyChanges() {
        AnalysisOptions analysisOptions = AnalysisOptions.getInstance();
        analysisOptions.setMessDetectorPath(this.getMessDetectorPath());
        analysisOptions.setMessDetectorRuleSets(this.getMessDetectorRuleSets());
    }

    @Override
    public boolean isChanged() {
        String saved = AnalysisOptions.getInstance().getMessDetectorPath();
        String current = this.getMessDetectorPath().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        return !AnalysisOptions.getInstance().getMessDetectorRuleSets().equals(this.getMessDetectorRuleSets());
    }

    @Override
    public ValidationResult getValidationResult() {
        return new AnalysisOptionsValidator().validateMessDetector(this.getMessDetectorPath(), this.getMessDetectorRuleSets()).getResult();
    }

    private void initComponents() {
        this.messDetectorLabel = new JLabel();
        this.messDetectorTextField = new JTextField();
        this.messDetectorBrowseButton = new JButton();
        this.messDetectorSearchButton = new JButton();
        this.messDetectorHintLabel = new JLabel();
        this.messDetectorRuleSetsLabel = new JLabel();
        this.messDetectorRuleSetsScrollPane = new JScrollPane();
        this.messDetectorRuleSetsList = new JList();
        this.noteLabel = new JLabel();
        this.minVersionInfoLabel = new JLabel();
        this.messDetectorLearnMoreLabel = new JLabel();
        this.messDetectorLabel.setLabelFor(this.messDetectorTextField);
        Mnemonics.setLocalizedText((JLabel)this.messDetectorLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.messDetectorBrowseButton, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorBrowseButton.text"));
        this.messDetectorBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessDetectorOptionsPanel.this.messDetectorBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.messDetectorSearchButton, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorSearchButton.text"));
        this.messDetectorSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessDetectorOptionsPanel.this.messDetectorSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.messDetectorHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.messDetectorRuleSetsLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorRuleSetsLabel.text"));
        this.messDetectorRuleSetsScrollPane.setViewportView(this.messDetectorRuleSetsList);
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.minVersionInfoLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.minVersionInfoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.messDetectorLearnMoreLabel, (String)NbBundle.getMessage(MessDetectorOptionsPanel.class, (String)"MessDetectorOptionsPanel.messDetectorLearnMoreLabel.text"));
        this.messDetectorLearnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MessDetectorOptionsPanel.this.messDetectorLearnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                MessDetectorOptionsPanel.this.messDetectorLearnMoreLabelMousePressed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.noteLabel, -2, -1, -2).addGap(0, 496, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messDetectorLabel).addComponent(this.messDetectorRuleSetsLabel)).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.messDetectorRuleSetsScrollPane, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addComponent(this.messDetectorTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messDetectorBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messDetectorSearchButton)).addGroup(layout.createSequentialGroup().addComponent(this.messDetectorHintLabel).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minVersionInfoLabel).addComponent(this.messDetectorLearnMoreLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.messDetectorBrowseButton, this.messDetectorSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messDetectorTextField, -2, -1, -2).addComponent(this.messDetectorSearchButton).addComponent(this.messDetectorBrowseButton).addComponent(this.messDetectorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messDetectorHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.messDetectorRuleSetsScrollPane, -2, -1, -2).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2)).addComponent(this.messDetectorRuleSetsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minVersionInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messDetectorLearnMoreLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
    }

    private void messDetectorLearnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void messDetectorLearnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://phpmd.org/");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void messDetectorBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(MessDetectorOptionsPanel.class.getName() + MESS_DETECTOR_LAST_FOLDER_SUFFIX).setFilesOnly(true).setTitle(Bundle.MessDetectorOptionsPanel_browse_title()).showOpenDialog();
        if (file != null) {
            this.messDetectorTextField.setText(file.getAbsolutePath());
        }
    }

    private void messDetectorSearchButtonActionPerformed(ActionEvent evt) {
        String messDetector = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])new String[]{"phpmd", MessDetector.LONG_NAME});
            }

            public String getWindowTitle() {
                return Bundle.MessDetectorOptionsPanel_search_title();
            }

            public String getListTitle() {
                return Bundle.MessDetectorOptionsPanel_search_scripts();
            }

            public String getPleaseWaitPart() {
                return Bundle.MessDetectorOptionsPanel_search_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.MessDetectorOptionsPanel_search_notFound();
            }
        });
        if (messDetector != null) {
            this.messDetectorTextField.setText(messDetector);
        }
    }

    private final class DefaultListSelectionListener
    implements ListSelectionListener {
        private DefaultListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            MessDetectorOptionsPanel.this.fireChange();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            MessDetectorOptionsPanel.this.fireChange();
        }
    }
}

