/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.session;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServerHttpAsyncRequestControl;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.sockjs.SockJsException;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.frame.SockJsFrame;
import org.springframework.web.socket.sockjs.frame.SockJsFrameFormat;
import org.springframework.web.socket.sockjs.transport.SockJsServiceConfig;
import org.springframework.web.socket.sockjs.transport.session.AbstractSockJsSession;

public abstract class AbstractHttpSockJsSession
extends AbstractSockJsSession {
    private final BlockingQueue<String> messageCache;
    private ServerHttpRequest request;
    private ServerHttpResponse response;
    private ServerHttpAsyncRequestControl asyncRequestControl;
    private SockJsFrameFormat frameFormat;
    private URI uri;
    private HttpHeaders handshakeHeaders;
    private Principal principal;
    private InetSocketAddress localAddress;
    private InetSocketAddress remoteAddress;
    private String acceptedProtocol;

    public AbstractHttpSockJsSession(String id, SockJsServiceConfig config, WebSocketHandler wsHandler, Map<String, Object> handshakeAttributes) {
        super(id, config, wsHandler, handshakeAttributes);
        this.messageCache = new ArrayBlockingQueue<String>(config.getHttpMessageCacheSize());
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public HttpHeaders getHandshakeHeaders() {
        return this.handshakeHeaders;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setAcceptedProtocol(String protocol) {
        this.acceptedProtocol = protocol;
    }

    @Override
    public String getAcceptedProtocol() {
        return this.acceptedProtocol;
    }

    @Override
    public List<WebSocketExtension> getExtensions() {
        return Collections.emptyList();
    }

    public synchronized void handleInitialRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrameFormat frameFormat) throws SockJsException {
        this.initRequest(request, response, frameFormat);
        this.uri = request.getURI();
        this.handshakeHeaders = request.getHeaders();
        this.principal = request.getPrincipal();
        this.localAddress = request.getLocalAddress();
        this.remoteAddress = request.getRemoteAddress();
        try {
            this.writePrelude();
            this.writeFrame(SockJsFrame.openFrame());
        }
        catch (Throwable ex) {
            this.tryCloseWithSockJsTransportError(ex, CloseStatus.SERVER_ERROR);
            throw new SockJsTransportFailureException("Failed to send \"open\" frame", this.getId(), ex);
        }
        try {
            this.delegateConnectionEstablished();
        }
        catch (Throwable ex) {
            throw new SockJsException("Unhandled exception from WebSocketHandler", this.getId(), ex);
        }
    }

    private void initRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrameFormat frameFormat) {
        Assert.notNull((Object)request, (String)"Request must not be null");
        Assert.notNull((Object)response, (String)"Response must not be null");
        Assert.notNull((Object)frameFormat, (String)"SockJsFrameFormat must not be null");
        this.request = request;
        this.response = response;
        this.asyncRequestControl = request.getAsyncRequestControl(response);
        this.frameFormat = frameFormat;
    }

    protected void writePrelude() throws IOException {
    }

    public synchronized void handleSuccessiveRequest(ServerHttpRequest request, ServerHttpResponse response, SockJsFrameFormat frameFormat) throws SockJsException {
        this.initRequest(request, response, frameFormat);
        try {
            this.writePrelude();
        }
        catch (Throwable ex) {
            this.tryCloseWithSockJsTransportError(ex, CloseStatus.SERVER_ERROR);
            throw new SockJsTransportFailureException("Failed to send \"open\" frame", this.getId(), ex);
        }
        this.startAsyncRequest();
    }

    protected void startAsyncRequest() throws SockJsException {
        try {
            this.asyncRequestControl.start(-1L);
            this.scheduleHeartbeat();
            this.tryFlushCache();
        }
        catch (Throwable ex) {
            this.tryCloseWithSockJsTransportError(ex, CloseStatus.SERVER_ERROR);
            throw new SockJsTransportFailureException("Failed to flush messages", this.getId(), ex);
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.asyncRequestControl != null && !this.asyncRequestControl.isCompleted();
    }

    protected BlockingQueue<String> getMessageCache() {
        return this.messageCache;
    }

    protected ServerHttpRequest getRequest() {
        return this.request;
    }

    protected ServerHttpResponse getResponse() {
        return this.response;
    }

    @Override
    protected final synchronized void sendMessageInternal(String message) throws SockJsTransportFailureException {
        this.messageCache.add(message);
        this.tryFlushCache();
    }

    private void tryFlushCache() throws SockJsTransportFailureException {
        if (this.messageCache.isEmpty()) {
            this.logger.trace((Object)"Nothing to flush");
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.messageCache.size() + " message(s) to flush"));
        }
        if (this.isActive()) {
            this.logger.trace((Object)"Flushing messages");
            this.flushCache();
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Not ready to flush");
        }
    }

    protected abstract void flushCache() throws SockJsTransportFailureException;

    @Override
    protected void disconnect(CloseStatus status) {
        this.resetRequest();
    }

    protected synchronized void resetRequest() {
        this.updateLastActiveTime();
        if (this.isActive() && this.asyncRequestControl.isStarted()) {
            try {
                this.logger.debug((Object)"Completing asynchronous request");
                this.asyncRequestControl.complete();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Failed to complete request: " + ex.getMessage()));
            }
        }
        this.request = null;
        this.response = null;
        this.asyncRequestControl = null;
    }

    @Override
    protected synchronized void writeFrameInternal(SockJsFrame frame) throws IOException {
        if (this.isActive()) {
            frame = this.frameFormat.format(frame);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Writing " + frame));
            }
            this.response.getBody().write(frame.getContentBytes());
        }
    }
}

