/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.j2ee;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.j2ee.support.J2eeUtil;
import org.netbeans.modules.websvc.saas.codegen.java.SoapClientPojoCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientOperationInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientSaasBean;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SoapClientServletCodeGenerator
extends SoapClientPojoCodeGenerator {
    public SoapClientServletCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.SERVLET);
        this.setPrecedence(1);
    }

    public boolean canAccept(SaasMethod method, Document doc) {
        return SaasBean.canAccept((SaasMethod)method, WsdlSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && J2eeUtil.isServlet(NbEditorUtilities.getDataObject((Document)doc));
    }

    protected void preGenerate() throws IOException {
        super.preGenerate();
        SoapClientOperationInfo[] operations = this.getBean().getOperationInfos();
        ArrayList<WSService> services = new ArrayList<WSService>();
        for (SoapClientOperationInfo info : operations) {
            WSService service;
            if (!info.isRPCEncoded() || services.contains(service = info.getService())) continue;
            services.add(service);
            this.preGenerateRpcClient(info, service);
        }
    }

    public void init(SaasMethod m, Document doc) throws IOException {
        super.init(m, doc);
        WsdlSaasMethod wsm = (WsdlSaasMethod)m;
        Project p = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)doc));
        SoapClientSaasBean bean = new SoapClientSaasBean(wsm, p, (SoapClientOperationInfo[])J2eeUtil.toJaxwsOperationInfos(wsm, p));
        this.setBean((SaasBean)bean);
    }

    private void preGenerateRpcClient(SoapClientOperationInfo info, WSService service) throws IOException {
        WebServicesClientSupport support = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.getTargetFile());
        if (support != null) {
            FileObject mappingFO;
            FileObject catalogDir;
            String wsdlLocation = info.getWsdlLocation();
            File wsdlFile = new File(wsdlLocation);
            FileObject wsdlFO = FileUtil.toFileObject((File)wsdlFile);
            FileObject projectWsdlFolder = support.getWsdlFolder(true);
            if (projectWsdlFolder.getFileObject(wsdlFO.getName(), wsdlFO.getExt()) == null) {
                FileUtil.copyFile((FileObject)wsdlFO, (FileObject)projectWsdlFolder, (String)wsdlFO.getName());
            }
            if ((catalogDir = this.getCatalogDir(info)) != null && (mappingFO = catalogDir.getFileObject("mapping.xml")) != null && projectWsdlFolder.getFileObject(mappingFO.getName(), mappingFO.getExt()) == null) {
                FileUtil.copyFile((FileObject)mappingFO, (FileObject)projectWsdlFolder, (String)mappingFO.getName());
            }
            String serviceName = "service/" + service.getName();
            String fqServiceName = service.getJavaName();
            wsdlLocation = wsdlLocation.substring(wsdlLocation.lastIndexOf(File.separator) + 1);
            wsdlLocation = "WEB-INF/wsdl/" + wsdlLocation;
            String mappingFile = "WEB-INF/wsdl/mapping.xml";
            List ports = service.getPorts();
            String[] portClasses = new String[ports.size()];
            for (int i = 0; i < ports.size(); ++i) {
                portClasses[i] = ((WSPort)ports.get(i)).getJavaName();
            }
            support.addServiceClientReference(serviceName, fqServiceName, wsdlLocation, mappingFile, portClasses);
        }
    }

    private FileObject findParentDir(FileObject originDir, String parentDirName) {
        if (originDir == null || originDir.getName().equals(parentDirName)) {
            return originDir;
        }
        return this.findParentDir(originDir.getParent(), parentDirName);
    }

    private FileObject getCatalogDir(SoapClientOperationInfo info) throws IOException {
        FileObject parent = null;
        String wsdlLocation = info.getWsdlLocation();
        File wsdlFile = new File(wsdlLocation);
        if (wsdlFile.exists()) {
            FileObject wsdlFO = FileUtil.toFileObject((File)wsdlFile);
            parent = this.findParentDir(wsdlFO.getParent(), "catalog");
        }
        return parent;
    }
}

