/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.awt.EventQueue;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitRebaseResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepository;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.client.ProgressDelegate;
import org.netbeans.modules.git.ui.actions.ActionProgress;
import org.netbeans.modules.git.ui.actions.ActionProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.fetch.Bundle;
import org.netbeans.modules.git.ui.fetch.FetchAction;
import org.netbeans.modules.git.ui.fetch.FetchUtils;
import org.netbeans.modules.git.ui.fetch.PullWizard;
import org.netbeans.modules.git.ui.merge.MergeRevisionAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.rebase.RebaseAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PullAction
extends SingleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/pull-setting.png";
    private static final Logger LOG = Logger.getLogger(PullAction.class.getName());

    public PullAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.pull(repository);
    }

    public void pull(final File repository, GitRemoteConfig remote, String branchToMerge) {
        if (remote.getUris().size() != 1) {
            Utils.post((Runnable)new Runnable(){

                @Override
                public void run() {
                    PullAction.this.pull(repository);
                }
            });
        } else {
            this.pull(repository, (String)remote.getUris().get(0), remote.getFetchRefSpecs(), branchToMerge, null);
        }
    }

    private void pull(final File repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        try {
            info.refreshRemotes();
        }
        catch (GitException ex) {
            GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
        }
        final Map<String, GitRemoteConfig> remotes = info.getRemotes();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PullWizard wiz = new PullWizard(repository, remotes);
                if (wiz.show()) {
                    Utils.logVCSExternalRepository((String)"GIT", (String)wiz.getFetchUri());
                    PullAction.this.pull(repository, wiz.getFetchUri(), wiz.getFetchRefSpecs(), wiz.getBranchToMerge(), wiz.getRemoteToPersist());
                }
            }
        });
    }

    public ActionProgress pull(File repository, String target, List<String> fetchRefSpecs, String branchToMerge, String remoteNameToUpdate) {
        GitProgressSupportImpl supp = new GitProgressSupportImpl(fetchRefSpecs, branchToMerge, target, remoteNameToUpdate);
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_PullAction_progressName(repository.getName()));
        return new ActionProgress.DefaultActionProgress(supp);
    }

    public static final class BranchSynchronizer
    extends ActionProgressSupport {
        private final GitProgressSupportDelegate delegate;
        private final File repository;
        private final String branchToMerge;

        public BranchSynchronizer(String branchToMerge, File repository, GitProgressSupportDelegate delegate) {
            super(delegate);
            this.repository = repository;
            this.branchToMerge = branchToMerge;
            this.delegate = delegate;
        }

        @Override
        protected Callable<ActionProgress> getNextAction() {
            Merge nextAction = null;
            try {
                GitClient client = this.delegate.getClient();
                String currentHeadId = null;
                String branchId = null;
                Map<String, GitBranch> branches = client.getBranches(true, GitUtils.NULL_PROGRESS_MONITOR);
                for (Map.Entry<String, GitBranch> e : branches.entrySet()) {
                    if (e.getValue().isActive()) {
                        currentHeadId = e.getValue().getId();
                    }
                    if (!e.getKey().equals(this.branchToMerge)) continue;
                    branchId = e.getValue().getId();
                }
                if (branchId == null || currentHeadId == null) {
                    nextAction = new Merge();
                } else if (!branchId.equals(currentHeadId)) {
                    GitRevisionInfo info = client.getCommonAncestor(new String[]{currentHeadId, branchId}, GitUtils.NULL_PROGRESS_MONITOR);
                    if (info == null || !info.getRevision().equals(branchId) && !info.getRevision().equals(currentHeadId)) {
                        return this.askForNextAction();
                    }
                    if (info.getRevision().equals(currentHeadId)) {
                        nextAction = new Merge();
                    }
                }
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, null, ex);
            }
            return nextAction;
        }

        private Callable<ActionProgress> askForNextAction() {
            JButton btnMerge = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnMerge, (String)Bundle.CTL_PullAction_mergeButton_text());
            btnMerge.setToolTipText(Bundle.CTL_PullAction_mergeButton_TTtext());
            JButton btnRebase = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnRebase, (String)Bundle.CTL_PullAction_rebaseButton_text());
            btnRebase.setToolTipText(Bundle.CTL_PullAction_rebaseButton_TTtext());
            Object value = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_PullAction_mergeNeeded_text(this.branchToMerge), Bundle.LBL_PullAction_mergeNeeded_title(), -1, 3, new Object[]{btnRebase, btnMerge, NotifyDescriptor.CANCEL_OPTION}, (Object)btnRebase));
            if (value == btnMerge) {
                return new Merge();
            }
            if (value == btnRebase) {
                return new Rebase();
            }
            return null;
        }

        private class Rebase
        implements Callable<ActionProgress> {
            private Rebase() {
            }

            @Override
            public ActionProgress call() throws GitException {
                BranchSynchronizer.this.delegate.getProgress().setDisplayName(Bundle.MSG_PullAction_rebasing());
                GitClient.RebaseOperationType op = GitClient.RebaseOperationType.BEGIN;
                GitClient client = BranchSynchronizer.this.delegate.getClient();
                String origHead = client.log("HEAD", BranchSynchronizer.this.delegate.getProgress().getProgressMonitor()).getRevision();
                RebaseAction.RebaseResultProcessor rrp = new RebaseAction.RebaseResultProcessor(client, BranchSynchronizer.this.repository, BranchSynchronizer.this.branchToMerge, BranchSynchronizer.this.branchToMerge, origHead, BranchSynchronizer.this.delegate.getProgress(), BranchSynchronizer.this.delegate.getLogger());
                while (op != null && !BranchSynchronizer.this.delegate.getProgress().isCanceled()) {
                    GitRebaseResult result = client.rebase(op, BranchSynchronizer.this.branchToMerge, BranchSynchronizer.this.delegate.getProgress().getProgressMonitor());
                    rrp.processResult(result);
                    op = rrp.getNextAction();
                    if (op != null || result.getRebaseStatus() != GitRebaseResult.RebaseStatus.FAST_FORWARD && result.getRebaseStatus() != GitRebaseResult.RebaseStatus.NOTHING_TO_COMMIT && result.getRebaseStatus() != GitRebaseResult.RebaseStatus.NOTHING_TO_COMMIT && result.getRebaseStatus() != GitRebaseResult.RebaseStatus.OK && result.getRebaseStatus() != GitRebaseResult.RebaseStatus.UP_TO_DATE) continue;
                    return new ActionProgress.ActionResult(false, false);
                }
                return new ActionProgress.ActionResult(BranchSynchronizer.this.delegate.getProgress().isCanceled(), true);
            }
        }

        private class Merge
        implements Callable<ActionProgress> {
            private Merge() {
            }

            @Override
            public ActionProgress call() throws GitException {
                GitClient client = BranchSynchronizer.this.delegate.getClient();
                BranchSynchronizer.this.delegate.getProgress().setDisplayName(Bundle.MSG_PullAction_merging());
                MergeRevisionAction.MergeContext ctx = new MergeRevisionAction.MergeContext(BranchSynchronizer.this.branchToMerge, null);
                MergeRevisionAction.MergeResultProcessor mrp = new MergeRevisionAction.MergeResultProcessor(client, BranchSynchronizer.this.repository, ctx, BranchSynchronizer.this.delegate.getLogger(), BranchSynchronizer.this.delegate.getProgress().getProgressMonitor());
                do {
                    ctx.setContinue(false);
                    GitRepository.FastForwardOption ffOption = GitRepository.FastForwardOption.FAST_FORWARD;
                    try {
                        GitMergeResult result = client.merge(BranchSynchronizer.this.branchToMerge, ffOption, BranchSynchronizer.this.delegate.getProgress().getProgressMonitor());
                        mrp.processResult(result);
                        if (result.getMergeStatus() == GitMergeResult.MergeStatus.ALREADY_UP_TO_DATE || result.getMergeStatus() == GitMergeResult.MergeStatus.FAST_FORWARD || result.getMergeStatus() == GitMergeResult.MergeStatus.MERGED) {
                            return new ActionProgress.ActionResult(false, false);
                        }
                    }
                    catch (GitException.CheckoutConflictException ex) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "Local modifications in WT during merge: {0} - {1}", new Object[]{BranchSynchronizer.this.repository, Arrays.asList(ex.getConflicts())});
                        }
                        ctx.setContinue(mrp.resolveLocalChanges(ex.getConflicts()));
                    }
                } while (ctx.isContinue() && !BranchSynchronizer.this.delegate.getProgress().isCanceled());
                return new ActionProgress.ActionResult(BranchSynchronizer.this.delegate.getProgress().isCanceled(), true);
            }
        }

        public static interface GitProgressSupportDelegate
        extends ActionProgressSupport.GitProgressSupportDelegate {
            public GitClient getClient() throws GitException;

            public OutputLogger getLogger();
        }
    }

    private static class GitProgressSupportImpl
    extends GitProgressSupport {
        private final List<String> fetchRefSpecs;
        private final String branchToMerge;
        private final String target;
        private final String remoteNameToUpdate;

        public GitProgressSupportImpl(List<String> fetchRefSpecs, String branchToMerge, String target, String remoteNameToUpdate) {
            this.fetchRefSpecs = fetchRefSpecs;
            this.branchToMerge = branchToMerge;
            this.target = target;
            this.remoteNameToUpdate = remoteNameToUpdate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void perform() {
            HashSet<String> toDelete;
            GitClient client;
            File repository;
            block7: {
                GitRemoteConfig config;
                block8: {
                    repository = this.getRepositoryRoot();
                    LOG.log(Level.FINE, "Pulling {0}/{1} from {2}", new Object[]{this.fetchRefSpecs, this.branchToMerge, this.target});
                    client = this.getClient();
                    toDelete = new HashSet<String>();
                    ListIterator<String> it = this.fetchRefSpecs.listIterator();
                    while (it.hasNext()) {
                        String refSpec = it.next();
                        if (!refSpec.startsWith(":refs/remotes/")) continue;
                        it.remove();
                        toDelete.add(refSpec.substring(":refs/remotes/".length()));
                    }
                    if (this.remoteNameToUpdate == null) break block7;
                    config = client.getRemote(this.remoteNameToUpdate, this.getProgressMonitor());
                    if (!this.isCanceled()) break block8;
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                    return;
                }
                config = GitUtils.prepareConfig(config, this.remoteNameToUpdate, this.target, this.fetchRefSpecs);
                client.setRemote(config, this.getProgressMonitor());
                if (!this.isCanceled()) break block7;
                this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                GitUtils.headChanged(repository);
                return;
            }
            try {
                GitUtils.runWithoutIndexing(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        for (String branch : toDelete) {
                            client.deleteBranch(branch, true, GitProgressSupportImpl.this.getProgressMonitor());
                            GitProgressSupportImpl.this.getLogger().outputLine(Bundle.MSG_PullAction_branchDeleted(branch));
                        }
                        GitProgressSupportImpl.this.setDisplayName(Bundle.MSG_PullAction_fetching());
                        Map<String, GitTransportUpdate> fetchResult = FetchAction.fetchRepeatedly(client, GitProgressSupportImpl.this.getProgressMonitor(), GitProgressSupportImpl.this.target, GitProgressSupportImpl.this.fetchRefSpecs);
                        if (GitProgressSupportImpl.this.isCanceled()) {
                            return null;
                        }
                        FetchUtils.log(repository, fetchResult, GitProgressSupportImpl.this.getLogger());
                        if (!GitProgressSupportImpl.this.isCanceled()) {
                            GitProgressSupportImpl.this.setDisplayName(Bundle.MSG_PullAction_progress_syncBranches());
                            FetchUtils.syncTrackingBranches(repository, fetchResult, GitProgressSupportImpl.this, GitProgressSupportImpl.this.getProgress(), false);
                        }
                        if (GitProgressSupportImpl.this.isCanceled() || GitProgressSupportImpl.this.branchToMerge == null) {
                            return null;
                        }
                        new BranchSynchronizer(GitProgressSupportImpl.this.branchToMerge, repository, new BranchSynchronizer.GitProgressSupportDelegate(){

                            @Override
                            public GitClient getClient() throws GitException {
                                return client;
                            }

                            @Override
                            public OutputLogger getLogger() {
                                return GitProgressSupportImpl.this.getLogger();
                            }

                            @Override
                            public ProgressDelegate getProgress() {
                                return GitProgressSupportImpl.this.getProgress();
                            }
                        }).execute();
                        return null;
                    }
                }, repository);
            }
            catch (GitException ex) {
                try {
                    this.setError(true);
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                catch (Throwable throwable) {
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                    throw throwable;
                }
                this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                GitUtils.headChanged(repository);
            }
            this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
            Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
            GitUtils.headChanged(repository);
        }
    }
}

