/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core.operations;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.operations.ICancellable;
import org.eclipse.mylyn.commons.core.operations.ICancellableOperation;
import org.eclipse.mylyn.commons.core.operations.Operation;
import org.eclipse.osgi.util.NLS;

public abstract class MonitoredOperation<T>
extends Operation<T>
implements ICancellableOperation {
    private static ThreadLocal<MonitoredOperation<?>> currentOperation = new ThreadLocal();
    private final CopyOnWriteArrayList<ICancellable> listeners = new CopyOnWriteArrayList();
    private final IProgressMonitor monitor;

    public static MonitoredOperation<?> getCurrentOperation() {
        return currentOperation.get();
    }

    static void setCurrentOperation(MonitoredOperation<?> operation) {
        if (operation != null && currentOperation.get() != null) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.core", NLS.bind((String)"Unexpected operation already in progress ''{0}''", currentOperation.get()), (Throwable)new IllegalStateException()));
        }
        currentOperation.set(operation);
    }

    public MonitoredOperation(IProgressMonitor monitor) {
        Assert.isNotNull((Object)monitor);
        this.monitor = monitor;
    }

    @Override
    public void abort() {
        ICancellable[] iCancellableArray = this.listeners.toArray(new ICancellable[0]);
        int n = iCancellableArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICancellable listener = iCancellableArray[n2];
            try {
                listener.abort();
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    @Override
    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    public void addListener(ICancellable listener) {
        this.listeners.add(listener);
    }

    @Override
    public T call() throws Exception {
        try {
            assert (MonitoredOperation.getCurrentOperation() == null);
            MonitoredOperation.setCurrentOperation(this);
            T t = this.execute();
            return t;
        }
        finally {
            MonitoredOperation.setCurrentOperation(null);
            this.listeners.clear();
        }
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void removeListener(ICancellable listener) {
        this.listeners.remove(listener);
    }

    protected abstract T execute() throws Exception;
}

