/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.jumpto.symbol;

import java.util.Collection;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.jumpto.symbol.SymbolProviderAccessor;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.Parameters;

public interface SymbolProvider {
    public String name();

    public String getDisplayName();

    public void computeSymbolNames(Context var1, Result var2);

    public void cancel();

    public void cleanup();

    public static final class Result {
        private final Collection<? super SymbolDescriptor> result;
        private final String[] message;
        private final SymbolProvider provider;
        private String highlightText;
        private boolean dirty;
        private boolean highlightTextAlreadySet;
        private int retry;

        Result(@NonNull Collection<? super SymbolDescriptor> result, @NonNull String[] message, @NonNull Context context, @NonNull SymbolProvider provider) {
            Parameters.notNull((CharSequence)"result", result);
            Parameters.notNull((CharSequence)"message", (Object)message);
            Parameters.notNull((CharSequence)"context", (Object)context);
            Parameters.notNull((CharSequence)"provider", (Object)provider);
            if (message.length != 1) {
                throw new IllegalArgumentException("message.length != 1");
            }
            this.result = result;
            this.message = message;
            this.highlightText = context.getText();
            this.provider = provider;
        }

        public void setMessage(String msg) {
            this.message[0] = msg;
        }

        public void addResult(SymbolDescriptor symbolDescriptor) {
            this.dirty = true;
            symbolDescriptor.setHighlightText(this.highlightText);
            symbolDescriptor.setSymbolProvider(this.provider);
            this.result.add(symbolDescriptor);
        }

        public void addResult(List<? extends SymbolDescriptor> symbolDescriptors) {
            for (SymbolDescriptor symbolDescriptor : symbolDescriptors) {
                this.addResult(symbolDescriptor);
            }
        }

        public void setHighlightText(@NonNull String textToHighlight) {
            Parameters.notNull((CharSequence)"textToHighlight", (Object)textToHighlight);
            if (this.dirty) {
                throw new IllegalStateException("Calling setHighlightText after addResult");
            }
            if (this.highlightTextAlreadySet) {
                throw new IllegalStateException("Highlight text already set");
            }
            this.highlightText = textToHighlight;
            this.highlightTextAlreadySet = true;
        }

        public void pendingResult() {
            this.retry = 2000;
        }
    }

    public static final class Context {
        private final Project project;
        private final String text;
        private final SearchType type;

        Context(Project project, String text, SearchType type) {
            this.project = project;
            this.text = text;
            this.type = type;
        }

        public Project getProject() {
            return this.project;
        }

        public String getText() {
            return this.text;
        }

        public SearchType getSearchType() {
            return this.type;
        }

        static {
            SymbolProviderAccessor.DEFAULT = new SymbolProviderAccessor(){

                @Override
                public Context createContext(Project p, String text, SearchType t) {
                    return new Context(p, text, t);
                }

                @Override
                @NonNull
                public Result createResult(@NonNull Collection<? super SymbolDescriptor> result, @NonNull String[] message, @NonNull Context context, @NonNull SymbolProvider provider) {
                    return new Result(result, message, context, provider);
                }

                @Override
                public int getRetry(Result result) {
                    return result.retry;
                }

                @Override
                @NonNull
                public String getHighlightText(@NonNull SymbolDescriptor desc) {
                    return desc.getHighlightText();
                }

                @Override
                public void setHighlightText(@NonNull SymbolDescriptor desc, @NonNull String text) {
                    desc.setHighlightText(text);
                }

                @Override
                public SymbolProvider getSymbolProvider(SymbolDescriptor desc) {
                    return desc.getSymbolProvider();
                }

                @Override
                public void setSymbolProvider(SymbolDescriptor desc, SymbolProvider provider) {
                    desc.setSymbolProvider(provider);
                }
            };
        }
    }
}

