/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.j2ee.CopyOnSave;
import org.netbeans.modules.maven.j2ee.ModuleChangeReporterImpl;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.maven.j2ee.utils.Server;
import org.netbeans.modules.maven.j2ee.utils.ServerUtils;

public abstract class BaseEEModuleProvider
extends J2eeModuleProvider {
    protected Project project;
    protected String serverInstanceID;
    protected J2eeModule j2eemodule;
    protected CopyOnSave copyOnSave;
    protected ModuleChangeReporter changeReporter;

    public BaseEEModuleProvider(Project project) {
        this.project = project;
        this.changeReporter = new ModuleChangeReporterImpl();
    }

    public abstract J2eeModuleImplementation2 getModuleImpl();

    public boolean isOnlyCompileOnSaveEnabled() {
        return RunUtils.isCompileOnSaveEnabled((Project)this.project) && !MavenProjectSupport.isDeployOnSave(this.project);
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this.changeReporter;
    }

    @CheckForNull
    public J2eeModuleProvider.DeployOnSaveSupport getDeployOnSaveSupport() {
        return this.getCopyOnSave();
    }

    @CheckForNull
    public CopyOnSave getCopyOnSaveSupport() {
        return this.getCopyOnSave();
    }

    @CheckForNull
    private CopyOnSave getCopyOnSave() {
        if (this.copyOnSave == null) {
            this.copyOnSave = (CopyOnSave)this.project.getLookup().lookup(CopyOnSave.class);
            if (this.copyOnSave != null) {
                this.copyOnSave.initialize();
            }
        }
        return this.copyOnSave;
    }

    public synchronized J2eeModule getJ2eeModule() {
        if (this.j2eemodule == null) {
            this.j2eemodule = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)this.getModuleImpl());
        }
        return this.j2eemodule;
    }

    public void setServerInstanceID(String newId) {
        String oldId = null;
        if (this.serverInstanceID != null) {
            oldId = MavenProjectSupport.obtainServerID(this.serverInstanceID);
        }
        this.serverInstanceID = newId;
        this.fireServerChange(oldId, this.getServerID());
    }

    public String getServerInstanceID() {
        if (this.serverInstanceID != null) {
            return this.serverInstanceID;
        }
        Server server = ServerUtils.findServer(this.project);
        if (server != null) {
            return server.getServerInstanceID();
        }
        return "DEV-NULL";
    }

    public String getServerID() {
        String serverID;
        if (this.serverInstanceID != null && (serverID = MavenProjectSupport.obtainServerID(this.serverInstanceID)) != null) {
            return serverID;
        }
        Server server = ServerUtils.findServer(this.project);
        if (server != null) {
            return server.getServerID();
        }
        return "DEV-NULL";
    }
}

