/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;

final class ScaledBitmapIcon
implements Icon {
    private final Map<Double, Image> cache = new ConcurrentHashMap<Double, Image>();
    private final Image sourceImage;
    private final int width;
    private final int height;

    public ScaledBitmapIcon(Image sourceImage, int width, int height) {
        if (sourceImage == null) {
            throw new NullPointerException();
        }
        if (width <= 0) {
            throw new IllegalArgumentException();
        }
        if (height <= 0) {
            throw new IllegalArgumentException();
        }
        this.sourceImage = sourceImage;
        this.width = width;
        this.height = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image getScaledImage(GraphicsConfiguration gc, double dpiScaling) {
        Image ret = this.cache.get(dpiScaling);
        if (ret != null) {
            return ret;
        }
        BufferedImage img = gc.createCompatibleImage((int)Math.ceil((double)this.getIconWidth() * dpiScaling), (int)Math.ceil((double)this.getIconHeight() * dpiScaling), 3);
        double sourceWidth = this.sourceImage.getWidth(null);
        double sourceHeight = this.sourceImage.getHeight(null);
        if (sourceWidth >= 1.0 && sourceHeight >= 1.0) {
            Graphics2D imgG = (Graphics2D)img.getGraphics();
            try {
                imgG.setTransform(AffineTransform.getScaleInstance(dpiScaling * (double)this.getIconWidth() / sourceWidth, dpiScaling * (double)this.getIconHeight() / sourceHeight));
                imgG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                imgG.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                imgG.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                imgG.drawImage(this.sourceImage, 0, 0, null);
            }
            finally {
                imgG.dispose();
            }
            if (dpiScaling <= 3.0) {
                this.cache.put(dpiScaling, img);
            }
        }
        return img;
    }

    @Override
    public void paintIcon(Component c, Graphics g0, int x, int y) {
        Graphics2D g = (Graphics2D)g0;
        AffineTransform oldTransform = g.getTransform();
        g.translate(x, y);
        AffineTransform tx = g.getTransform();
        int txType = tx.getType();
        double dpiScaling = txType == 2 || txType == 3 ? tx.getScaleX() : 1.0;
        Image scaledImage = this.getScaledImage(g.getDeviceConfiguration(), dpiScaling);
        if (dpiScaling != 1.0) {
            AffineTransform tx2 = g.getTransform();
            g.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (int)tx2.getTranslateX(), (int)tx2.getTranslateY()));
        }
        g.drawImage(scaledImage, 0, 0, null);
        g.setTransform(oldTransform);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

