/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.IntHashSet;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class NameTest
extends NodeTest {
    private int nodeKind;
    private int fingerprint;
    private NamePool namePool;
    private String uri = null;
    private String localName = null;

    public NameTest(int nodeKind, String uri, String localName, NamePool namePool) {
        this.nodeKind = nodeKind;
        this.fingerprint = namePool.allocate("", uri, localName) & 0xFFFFF;
        this.namePool = namePool;
    }

    public NameTest(int nodeKind, int nameCode, NamePool namePool) {
        this.nodeKind = nodeKind;
        this.fingerprint = nameCode & 0xFFFFF;
        this.namePool = namePool;
    }

    public NameTest(NodeInfo node) {
        this.nodeKind = node.getNodeKind();
        this.fingerprint = node.getFingerprint();
        this.namePool = node.getNamePool();
    }

    public boolean matches(int nodeKind, int nameCode, int annotation) {
        return (nameCode & 0xFFFFF) == this.fingerprint && nodeKind == this.nodeKind;
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        return (tree.getNameCode(nodeNr) & 0xFFFFF) == this.fingerprint && tree.getNodeKind(nodeNr) == this.nodeKind;
    }

    public boolean matches(NodeInfo node) {
        if (node.getNodeKind() != this.nodeKind) {
            return false;
        }
        if (node instanceof FingerprintedNode) {
            return node.getFingerprint() == this.fingerprint;
        }
        if (this.uri == null) {
            this.uri = this.namePool.getURI(this.fingerprint);
        }
        if (this.localName == null) {
            this.localName = this.namePool.getLocalName(this.fingerprint);
        }
        return this.localName.equals(node.getLocalPart()) && this.uri.equals(node.getURI());
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getFingerprint() {
        return this.fingerprint;
    }

    public int getPrimitiveType() {
        return this.nodeKind;
    }

    public ItemType getSuperType(TypeHierarchy th) {
        return NodeKindTest.makeNodeKindTest(this.nodeKind);
    }

    public int getNodeKindMask() {
        return 1 << this.nodeKind;
    }

    public IntHashSet getRequiredNodeNames() {
        IntHashSet s = new IntHashSet(1);
        s.add(this.fingerprint);
        return s;
    }

    public String toString() {
        return this.toString(this.namePool);
    }

    public String toString(NamePool pool) {
        switch (this.nodeKind) {
            case 1: {
                return "element(" + pool.getClarkName(this.fingerprint) + ", xs:anyType)";
            }
            case 2: {
                return "attribute(" + pool.getClarkName(this.fingerprint) + ", xs:anyAtomicType)";
            }
            case 7: {
                return "processing-instruction(" + pool.getDisplayName(this.fingerprint) + ')';
            }
            case 13: {
                return "namespace(" + pool.getDisplayName(this.fingerprint) + ')';
            }
        }
        return pool.getDisplayName(this.fingerprint);
    }

    public int hashCode() {
        return this.nodeKind << 20 ^ this.fingerprint;
    }

    public boolean equals(Object other) {
        return other instanceof NameTest && ((NameTest)other).namePool == this.namePool && ((NameTest)other).nodeKind == this.nodeKind && ((NameTest)other).fingerprint == this.fingerprint;
    }
}

