/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileBuiltQuery;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class JavaFreeformFileBuiltQuery
implements FileBuiltQueryImplementation,
AntProjectListener {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(JavaFreeformFileBuiltQuery.class.getName());
    private Project project;
    private AntProjectHelper projectHelper;
    private PropertyEvaluator projectEvaluator;
    private AuxiliaryConfiguration aux;
    private FileBuiltQueryImplementation delegateTo;

    public JavaFreeformFileBuiltQuery(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
        this.project = project;
        this.projectHelper = projectHelper;
        this.projectEvaluator = projectEvaluator;
        this.aux = aux;
        this.delegateTo = null;
        projectHelper.addAntProjectListener((AntProjectListener)this);
    }

    private FileBuiltQueryImplementation createDelegateTo() {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "JavaFreeformFileBuiltQuery.createDelegateTo start");
        }
        Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/4", true);
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        if (java != null) {
            List compilationUnits = XMLUtil.findSubElements((Element)java);
            for (Element compilationUnitEl : compilationUnits) {
                assert (compilationUnitEl.getLocalName().equals("compilation-unit")) : compilationUnitEl;
                List<String> rootNames = Classpaths.findPackageRootNames(compilationUnitEl);
                List<String> builtToNames = JavaFreeformFileBuiltQuery.findBuiltToNames(compilationUnitEl);
                ArrayList<String> rootPatterns = new ArrayList<String>();
                String builtToPattern = null;
                for (String n : rootNames) {
                    rootPatterns.add(this.projectEvaluator.evaluate(n) + "/*.java");
                }
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "Looking for a suitable built-to:");
                }
                for (String n : builtToNames) {
                    boolean isFolder;
                    String builtTo = this.projectEvaluator.evaluate(n);
                    if (builtTo == null || !(isFolder = JavaProjectGenerator.isFolder(this.projectEvaluator, FileUtil.toFile((FileObject)this.project.getProjectDirectory()), builtTo)) || builtToPattern != null) continue;
                    builtToPattern = builtTo + "/*.class";
                    break;
                }
                if (builtToPattern != null) {
                    if (ERR.isLoggable(1)) {
                        ERR.log(1, "Found built to pattern=" + builtToPattern + ", rootPatterns=" + rootPatterns);
                    }
                    for (String p : rootPatterns) {
                        from.add(p);
                        to.add(builtToPattern);
                    }
                    continue;
                }
                if (!ERR.isLoggable(1)) continue;
                ERR.log(1, "No built to pattern found, rootPatterns=" + rootPatterns);
            }
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "JavaFreeformFileBuiltQuery from=" + from + " to=" + to);
        }
        String[] fromStrings = from.toArray(new String[from.size()]);
        String[] toStrings = to.toArray(new String[to.size()]);
        FileBuiltQueryImplementation fbqi = this.projectHelper.createGlobFileBuiltQuery(this.projectEvaluator, fromStrings, toStrings);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "JavaFreeformFileBuiltQuery.createDelegateTo end");
        }
        return fbqi;
    }

    public void propertiesChanged(AntProjectEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationXmlChanged(AntProjectEvent evt) {
        JavaFreeformFileBuiltQuery javaFreeformFileBuiltQuery = this;
        synchronized (javaFreeformFileBuiltQuery) {
            this.delegateTo = null;
        }
    }

    public FileBuiltQuery.Status getStatus(final FileObject fo) {
        return (FileBuiltQuery.Status)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileBuiltQuery.Status>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileBuiltQuery.Status run() {
                JavaFreeformFileBuiltQuery javaFreeformFileBuiltQuery = JavaFreeformFileBuiltQuery.this;
                synchronized (javaFreeformFileBuiltQuery) {
                    if (JavaFreeformFileBuiltQuery.this.delegateTo == null) {
                        JavaFreeformFileBuiltQuery.this.delegateTo = JavaFreeformFileBuiltQuery.this.createDelegateTo();
                    }
                    return JavaFreeformFileBuiltQuery.this.delegateTo.getStatus(fo);
                }
            }
        });
    }

    static List<String> findBuiltToNames(Element compilationUnitEl) {
        ArrayList<String> names = new ArrayList<String>();
        for (Element e : XMLUtil.findSubElements((Element)compilationUnitEl)) {
            if (!e.getLocalName().equals("built-to")) continue;
            String location = XMLUtil.findText((Node)e);
            names.add(location);
        }
        return names;
    }
}

