/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.portunif.util;

import com.sun.enterprise.web.connector.grizzly.OutputWriter;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLOutputWriter;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLSelectorThread;
import com.sun.enterprise.web.portunif.util.ProtocolInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tomcat.util.buf.Ascii;

public class Redirector {
    private static final String NEWLINE = "\r\n";
    private static String ipAddress = "127.0.0.1";
    private static final String headers = "\r\nConnection:close\r\nCache-control: private\r\n\r\n";
    private static final ByteBuffer SC_FOUND;

    public final void redirectSSL(ProtocolInfo protocolInfo) throws IOException {
        String host = this.parseHost(protocolInfo.byteBuffer);
        if (host == null) {
            host = ipAddress + ":" + protocolInfo.socketChannel.socket().getLocalPort();
        }
        this.redirectSSL(protocolInfo, protocolInfo.isRequestedTransportSecure ? new String("Location: https://" + host) : new String("Location: http://" + host));
    }

    private final void redirectSSL(ProtocolInfo protocolInfo, String httpHeaders) throws IOException {
        SSLOutputWriter.flushChannel(protocolInfo.socketChannel, SC_FOUND.slice(), protocolInfo.outputBB, protocolInfo.sslEngine);
        SSLOutputWriter.flushChannel(protocolInfo.socketChannel, ByteBuffer.wrap((httpHeaders + protocolInfo.requestURI + headers).getBytes()), protocolInfo.outputBB, protocolInfo.sslEngine);
    }

    public final void redirect(ProtocolInfo protocolInfo) throws IOException {
        String host = this.parseHost(protocolInfo.byteBuffer);
        if (host == null) {
            host = ipAddress + ":" + protocolInfo.socketChannel.socket().getLocalPort();
        }
        this.redirect(protocolInfo, protocolInfo.isRequestedTransportSecure ? new String("Location: https://" + host) : new String("Location: http://" + host));
    }

    private final void redirect(ProtocolInfo protocolInfo, String httpHeaders) throws IOException {
        OutputWriter.flushChannel(protocolInfo.socketChannel, SC_FOUND.slice());
        OutputWriter.flushChannel(protocolInfo.socketChannel, ByteBuffer.wrap((httpHeaders + protocolInfo.requestURI + headers).getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseHost(ByteBuffer byteBuffer) {
        String string;
        int end;
        int start;
        int curLimit;
        int curPosition;
        block26: {
            String string2;
            block24: {
                boolean isFound = false;
                curPosition = byteBuffer.position();
                curLimit = byteBuffer.limit();
                if (byteBuffer.position() == 0) {
                    return ipAddress;
                }
                byteBuffer.position(0);
                byteBuffer.limit(curPosition);
                int state = 0;
                start = 0;
                end = 0;
                try {
                    block25: {
                        try {
                            block12: while (byteBuffer.hasRemaining()) {
                                byte c = (byte)Ascii.toLower((int)byteBuffer.get());
                                switch (state) {
                                    case 0: {
                                        if (c == 104) {
                                            state = 1;
                                            continue block12;
                                        }
                                        state = 0;
                                        continue block12;
                                    }
                                    case 1: {
                                        if (c == 111) {
                                            state = 2;
                                            continue block12;
                                        }
                                        state = 0;
                                        continue block12;
                                    }
                                    case 2: {
                                        if (c == 115) {
                                            state = 3;
                                            continue block12;
                                        }
                                        state = 0;
                                        continue block12;
                                    }
                                    case 3: {
                                        if (c == 116) {
                                            state = 4;
                                            continue block12;
                                        }
                                        state = 0;
                                        continue block12;
                                    }
                                    case 4: {
                                        if (c == 58) {
                                            state = 5;
                                            continue block12;
                                        }
                                        state = 0;
                                        continue block12;
                                    }
                                    case 5: {
                                        StringBuilder sb = new StringBuilder();
                                        while (c != 13 && c != 10) {
                                            sb.append((char)c);
                                            c = byteBuffer.get();
                                        }
                                        string2 = sb.toString().trim();
                                        Object var12_14 = null;
                                        if (end <= 0) break block24;
                                        break block25;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Unexpected state");
                                    }
                                }
                            }
                            string = null;
                            break block26;
                        }
                        catch (BufferUnderflowException bue) {
                            String string3 = null;
                            Object var12_16 = null;
                            if (end > 0) {
                                byteBuffer.position(start);
                                byteBuffer.limit(end);
                                return string3;
                            }
                            byteBuffer.limit(curLimit);
                            byteBuffer.position(curPosition);
                            return string3;
                        }
                    }
                    byteBuffer.position(start);
                }
                catch (Throwable throwable) {
                    Object var12_17 = null;
                    if (end > 0) {
                        byteBuffer.position(start);
                        byteBuffer.limit(end);
                        throw throwable;
                    }
                    byteBuffer.limit(curLimit);
                    byteBuffer.position(curPosition);
                    throw throwable;
                }
                byteBuffer.limit(end);
                return string2;
            }
            byteBuffer.limit(curLimit);
            byteBuffer.position(curPosition);
            return string2;
        }
        Object var12_15 = null;
        if (end > 0) {
            byteBuffer.position(start);
            byteBuffer.limit(end);
            return string;
        }
        byteBuffer.limit(curLimit);
        byteBuffer.position(curPosition);
        return string;
    }

    private void log(Throwable ex) {
        Logger logger = SSLSelectorThread.logger();
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Redirector", ex);
        }
    }

    static {
        try {
            ipAddress = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SC_FOUND = ByteBuffer.wrap("HTTP/1.1 302 Moved Temporarily\r\n".getBytes());
    }
}

