/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SetThreadSuspensionEnabledNode;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SetThreadSuspensionEnabledNode.class)
final class SetThreadSuspensionEnabledNodeGen
extends SetThreadSuspensionEnabledNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private ExecuteCachedData executeCached_cache;

    private SetThreadSuspensionEnabledNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    protected void execute(boolean arg0Value, Breakpoint.SessionList arg1Value, long arg2Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0 && arg1Value.next == null) {
                ExecuteCachedData s1_ = this.executeCached_cache;
                while (s1_ != null) {
                    if (arg2Value == s1_.currentThreadId_) {
                        this.executeCached(arg0Value, arg1Value, arg2Value, s1_.currentThreadId_, s1_.threadSuspension_);
                        return;
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                this.executeGeneric(arg0Value, arg1Value, arg2Value);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(boolean arg0Value, Breakpoint.SessionList arg1Value, long arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0 && arg1Value.next == null) {
                long currentThreadId__;
                int count1_ = 0;
                ExecuteCachedData s1_ = this.executeCached_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null && arg2Value != s1_.currentThreadId_) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && arg2Value == (currentThreadId__ = SetThreadSuspensionEnabledNode.currentThreadId()) && count1_ < 10) {
                    s1_ = new ExecuteCachedData(this.executeCached_cache);
                    s1_.currentThreadId_ = currentThreadId__;
                    s1_.threadSuspension_ = this.getThreadSuspension(arg1Value);
                    this.executeCached_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.executeCached(arg0Value, arg1Value, arg2Value, s1_.currentThreadId_, s1_.threadSuspension_);
                    return;
                }
            }
            this.exclude_ = exclude |= 1;
            this.executeCached_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            this.executeGeneric(arg0Value, arg1Value, arg2Value);
            return;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        ExecuteCachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.executeCached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static SetThreadSuspensionEnabledNode create() {
        return new SetThreadSuspensionEnabledNodeGen();
    }

    @GeneratedBy(value=SetThreadSuspensionEnabledNode.class)
    private static final class ExecuteCachedData {
        @CompilerDirectives.CompilationFinal
        ExecuteCachedData next_;
        @CompilerDirectives.CompilationFinal
        long currentThreadId_;
        @CompilerDirectives.CompilationFinal
        DebuggerSession.ThreadSuspension threadSuspension_;

        ExecuteCachedData(ExecuteCachedData next_) {
            this.next_ = next_;
        }
    }
}

