/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;

public final class UnsupportedMessageException
extends InteropException {
    private static final long serialVersionUID = 1857745390734085182L;
    private static final Message LEGACY = new Message(){

        @Override
        public int hashCode() {
            return 13;
        }

        @Override
        public boolean equals(Object message) {
            return this == message;
        }
    };
    private final Message message;

    private UnsupportedMessageException() {
        this.message = LEGACY;
    }

    private UnsupportedMessageException(Message message) {
        this.message = message;
    }

    @Override
    public String getMessage() {
        return "Message not supported.";
    }

    @Deprecated
    public Message getUnsupportedMessage() {
        return this.message;
    }

    @Deprecated
    public static RuntimeException raise(Message message) {
        CompilerDirectives.transferToInterpreter();
        return UnsupportedMessageException.silenceException(RuntimeException.class, new UnsupportedMessageException(message));
    }

    public static UnsupportedMessageException create() {
        CompilerDirectives.transferToInterpreter();
        return new UnsupportedMessageException();
    }
}

