/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.persistence.dd.common.Property;
import org.netbeans.modules.j2ee.persistence.unit.PropertiesPanel;
import org.netbeans.modules.j2ee.persistence.unit.Util;
import org.openide.util.NbBundle;

public class PropertiesTableModel
extends AbstractTableModel {
    private static final String[] columnNames = new String[]{NbBundle.getMessage(PropertiesTableModel.class, (String)"LBL_Name"), NbBundle.getMessage(PropertiesTableModel.class, (String)"LBL_Value")};
    private static final String jpa_prefix = "javax.persistence.";
    private PropertiesPanel.PropertiesParamHolder propParam;
    private ArrayList<PropertyData> propsData;

    public PropertiesTableModel(PropertiesPanel.PropertiesParamHolder propParam) {
        this.propParam = propParam;
        this.getPropsData();
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.propParam == null || this.propParam.getPU() == null) {
            return null;
        }
        if (column == 0) {
            return this.propsData.get(row).getPropName();
        }
        return this.propsData.get(row).getPropValue();
    }

    @Override
    public int getRowCount() {
        if (this.propParam == null || this.propParam.getPU() == null) {
            return 0;
        }
        return this.propsData.size();
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void addRow(String propName, String propValue) {
        Property prop = this.propParam.getPU().getProperties().newProperty();
        prop.setName(propName);
        prop.setValue(propValue);
        int index = this.propParam.getPU().getProperties().addProperty2(prop);
        this.propsData.add(new PropertyData(index, propName, propValue));
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void editRow(int row, String propValue) {
        PropertyData data = this.propsData.get(row);
        Property tmp = this.propParam.getPU().getProperties().getProperty2(data.getModelIndex());
        tmp.setValue(propValue);
        data.setPropValue(propValue);
        this.fireTableRowsUpdated(row, row);
    }

    public void removeRow(int row) {
        this.propParam.getPU().getProperties().removeProperty2(this.propParam.getPU().getProperties().getProperty2(this.propsData.get(row).getModelIndex()));
        this.getPropsData();
        this.fireTableRowsDeleted(row, row);
    }

    private void getPropsData() {
        this.propsData = new ArrayList();
        List<String> allPropsOfThisCat = Util.getPropsNamesExceptGeneral(this.propParam.getProvider());
        if (this.propParam.getPU() != null && this.propParam.getPU().getProperties() != null) {
            for (int i = 0; i < this.propParam.getPU().getProperties().sizeProperty2(); ++i) {
                String propName = this.propParam.getPU().getProperties().getProperty2(i).getName();
                if (!allPropsOfThisCat.contains(propName) && !allPropsOfThisCat.contains(jpa_prefix + propName)) continue;
                String propValue = this.propParam.getPU().getProperties().getProperty2(i).getValue();
                this.propsData.add(new PropertyData(i, propName, propValue));
            }
        }
    }

    private static class PropertyData {
        private int modelIndex;
        private String name;
        private String value;

        public PropertyData(int modelIndex, String propName, String propValue) {
            this.modelIndex = modelIndex;
            this.name = propName;
            this.value = propValue;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public String getPropName() {
            return this.name;
        }

        public String getPropValue() {
            return this.value;
        }

        public void setPropValue(String value) {
            this.value = value;
        }
    }
}

