/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

public class PHPDocTypeTag
extends PHPDocTag {
    private final List<PHPDocTypeNode> types;
    protected String documentation;

    public PHPDocTypeTag(int start, int end, AnnotationParsedLine kind, String value, List<PHPDocTypeNode> types) {
        super(start, end, kind, value);
        this.types = types;
        this.documentation = null;
    }

    public List<PHPDocTypeNode> getTypes() {
        return this.types;
    }

    @Override
    public String getDocumentation() {
        if (this.documentation == null && this.types.size() > 0) {
            PHPDocTypeNode lastType = this.types.get(0);
            boolean isLastNodeArray = lastType.isArray();
            for (PHPDocTypeNode node : this.types) {
                if (lastType.getEndOffset() >= node.getEndOffset()) continue;
                lastType = node;
                isLastNodeArray = node.isArray();
            }
            int indexAfterTypeWithoutArrayPostfix = this.getValue().indexOf(lastType.getValue()) + lastType.getValue().length();
            if (isLastNodeArray) {
                String documentationWithArrayPrefix = this.getValue().substring(indexAfterTypeWithoutArrayPostfix).trim();
                int firstSpace = documentationWithArrayPrefix.indexOf(" ");
                int firstTab = documentationWithArrayPrefix.indexOf("\t");
                int min = -1;
                if (firstSpace > 0 && (firstSpace < firstTab || firstTab == -1)) {
                    min = firstSpace;
                } else if (firstTab > 0 && (firstTab < firstSpace || firstSpace == -1)) {
                    min = firstTab;
                }
                this.documentation = min == -1 ? "" : this.getValue().substring(indexAfterTypeWithoutArrayPostfix + min).trim();
            } else {
                this.documentation = this.getValue().substring(indexAfterTypeWithoutArrayPostfix).trim();
            }
        }
        return this.documentation;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

