/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.FinallyClause;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class TryStatement
extends Statement {
    private Block tryStatement;
    private ArrayList<CatchClause> catchClauses = new ArrayList();
    private final FinallyClause finallyClause;

    private TryStatement(int start, int end, Block tryStatement, CatchClause[] catchClauses, FinallyClause finallyClause) {
        super(start, end);
        if (tryStatement == null) {
            throw new IllegalArgumentException();
        }
        this.tryStatement = tryStatement;
        if (catchClauses != null) {
            this.catchClauses.addAll(Arrays.asList(catchClauses));
        }
        this.finallyClause = finallyClause;
    }

    public TryStatement(int start, int end, Block tryStatement, List<CatchClause> catchClauses, FinallyClause finallyClause) {
        this(start, end, tryStatement, catchClauses == null ? null : catchClauses.toArray(new CatchClause[catchClauses.size()]), finallyClause);
    }

    public Block getBody() {
        return this.tryStatement;
    }

    public List<CatchClause> getCatchClauses() {
        return this.catchClauses;
    }

    public FinallyClause getFinallyClause() {
        return this.finallyClause;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CatchClause catchClause : this.getCatchClauses()) {
            sb.append(catchClause);
        }
        return "try" + this.getBody() + sb.toString();
    }
}

