/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;
import java.util.PrimitiveIterator;

public final class NFAStateSet
extends StateSet<NFAState>
implements JsonConvertible {
    private int[] stateIndexMap;

    public NFAStateSet(NFA nfa) {
        super(nfa);
    }

    public NFAStateSet(NFA nfa, NFAState state) {
        super(nfa);
        this.add(state);
    }

    private NFAStateSet(NFAStateSet copy) {
        super(copy);
        this.stateIndexMap = copy.isStateIndexMapCreated() ? Arrays.copyOf(copy.stateIndexMap, copy.stateIndexMap.length) : null;
    }

    public NFAStateSet copy() {
        return new NFAStateSet(this);
    }

    private boolean isStateIndexMapCreated() {
        return this.stateIndexMap != null;
    }

    @Override
    public boolean add(NFAState state) {
        if (this.isStateIndexMapCreated()) {
            throw new IllegalStateException("state set must not be altered after state index map creation!");
        }
        return super.add(state);
    }

    private void createStateIndexMap() {
        if (!this.isStateIndexMapCreated()) {
            this.stateIndexMap = new int[this.size()];
            int i = 0;
            PrimitiveIterator.OfInt iterator = this.intIterator();
            while (iterator.hasNext()) {
                this.stateIndexMap[i++] = iterator.nextInt();
            }
            assert (NFAStateSet.isSorted(this.stateIndexMap));
        }
    }

    private static boolean isSorted(int[] array) {
        int prev = Integer.MIN_VALUE;
        for (int i : array) {
            if (prev > i) {
                return false;
            }
            prev = i;
        }
        return true;
    }

    public int getStateIndex(NFAState state) {
        this.createStateIndexMap();
        assert (this.contains(state));
        return Arrays.binarySearch(this.stateIndexMap, 0, this.size(), (int)state.getId());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.array(this);
    }
}

