/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.EconomicMap;

public final class NFATraceFinderGenerator {
    private final NFA originalNFA;
    private final List<NFAState> states;
    private final List<NFAState>[] duplicatedStatesMap;
    private final List<PreCalculatedResultFactory> resultList = new ArrayList<PreCalculatedResultFactory>();
    private final EconomicMap<PreCalculatedResultFactory, PreCalculatedResultFactory> resultDeDuplicationMap = EconomicMap.create();
    private final Counter.ThresholdCounter stateID = new Counter.ThresholdCounter(3500, "TraceFinder NFA explosion");
    private final Counter.ThresholdCounter transitionID = new Counter.ThresholdCounter(3500, "TraceFinder NFA transition explosion");

    private NFATraceFinderGenerator(NFA originalNFA) {
        this.originalNFA = originalNFA;
        this.states = new ArrayList<NFAState>(originalNFA.getStates().length * 2);
        this.duplicatedStatesMap = new ArrayList[originalNFA.getStates().length];
    }

    public static NFA generateTraceFinder(NFA nfa) {
        return new NFATraceFinderGenerator(nfa).run();
    }

    private NFA run() {
        NFAState dummyInitialState = this.copy(this.originalNFA.getDummyInitialState());
        NFAStateTransition newAnchoredEntry = this.copyEntry(dummyInitialState, this.originalNFA.getReverseAnchoredEntry());
        NFAStateTransition newUnAnchoredEntry = this.copyEntry(dummyInitialState, this.originalNFA.getReverseUnAnchoredEntry());
        dummyInitialState.setPrev(new NFAStateTransition[]{newAnchoredEntry, newUnAnchoredEntry});
        ArrayList<PathElement> graphPath = new ArrayList<PathElement>();
        for (NFAStateTransition entry : new NFAStateTransition[]{this.originalNFA.getAnchoredEntry()[0], this.originalNFA.getUnAnchoredEntry()[0]}) {
            block1: for (NFAStateTransition t : entry.getTarget().getNext()) {
                PathElement curElement = new PathElement(t);
                while (true) {
                    if (this.duplicatedStatesMap[curElement.getTransition().getTarget().getId()] == null) {
                        graphPath.add(curElement);
                        curElement = new PathElement(curElement.getNextTransition());
                        continue;
                    }
                    for (NFAState duplicate : this.duplicatedStatesMap[curElement.getTransition().getTarget().getId()]) {
                        int i;
                        int resultID = this.resultList.size();
                        if (resultID == 254) {
                            throw new UnsupportedRegexException("TraceFinder: too many possible results");
                        }
                        NFAState lastCopied = this.copy(entry.getTarget(), resultID);
                        PreCalculatedResultFactory result = this.resultFactory();
                        for (i = 0; i < graphPath.size(); ++i) {
                            NFAStateTransition pathTransition = ((PathElement)graphPath.get(i)).getTransition();
                            NFAState copy = this.copy(pathTransition.getTarget(), resultID);
                            this.createTransition(lastCopied, copy, pathTransition, result, i);
                            lastCopied = copy;
                        }
                        this.createTransition(lastCopied, duplicate, curElement.getTransition(), result, i);
                        NFAState treeNode = duplicate;
                        while (!treeNode.isForwardFinalState()) {
                            ++i;
                            assert (treeNode.getNext().length == 1);
                            treeNode.addPossibleResult(resultID);
                            treeNode.getNext()[0].getGroupBoundaries().applyToResultFactory(result, i);
                            treeNode = treeNode.getNext()[0].getTarget();
                        }
                        treeNode.addPossibleResult(resultID);
                        result.setLength(i);
                        PreCalculatedResultFactory existingResult = (PreCalculatedResultFactory)this.resultDeDuplicationMap.get((Object)result);
                        if (existingResult == null) {
                            this.resultDeDuplicationMap.put((Object)result, (Object)result);
                        } else {
                            result = existingResult;
                        }
                        this.resultList.add(result);
                        assert (this.resultList.get(resultID) == result);
                    }
                    while (!graphPath.isEmpty() && !((PathElement)graphPath.get(graphPath.size() - 1)).hasNextTransition()) {
                        graphPath.remove(graphPath.size() - 1);
                    }
                    if (graphPath.isEmpty()) continue block1;
                    curElement = new PathElement(((PathElement)graphPath.get(graphPath.size() - 1)).getNextTransition());
                }
            }
        }
        PreCalculatedResultFactory[] preCalculatedResults = this.resultDeDuplicationMap.size() == 1 ? new PreCalculatedResultFactory[]{this.resultList.get(0)} : this.resultList.toArray(new PreCalculatedResultFactory[0]);
        for (NFAState s : this.states) {
            s.linkPrev();
        }
        return new NFA(this.originalNFA.getAst(), dummyInitialState, null, null, newAnchoredEntry, newUnAnchoredEntry, this.states, this.stateID, this.transitionID, preCalculatedResults);
    }

    private void createTransition(NFAState source, NFAState target, NFAStateTransition originalTransition, PreCalculatedResultFactory preCalcResult, int preCalcResultIndex) {
        originalTransition.getGroupBoundaries().applyToResultFactory(preCalcResult, preCalcResultIndex);
        source.setNext(new NFAStateTransition[]{new NFAStateTransition((short)this.transitionID.inc(), source, target, originalTransition.getGroupBoundaries())}, true);
    }

    private PreCalculatedResultFactory resultFactory() {
        return new PreCalculatedResultFactory(this.originalNFA.getAst().getNumberOfCaptureGroups());
    }

    private NFAStateTransition copyEntry(NFAState dummyInitialState, NFAStateTransition originalReverseEntry) {
        return new NFAStateTransition((short)this.transitionID.inc(), this.copy(originalReverseEntry.getSource()), dummyInitialState, GroupBoundaries.getEmptyInstance());
    }

    private NFAState copy(NFAState s) {
        NFAState copy = s.createTraceFinderCopy((short)this.stateID.inc());
        this.registerCopy(s, copy);
        return copy;
    }

    private NFAState copy(NFAState s, int resultID) {
        NFAState copy = this.copy(s);
        copy.addPossibleResult(resultID);
        return copy;
    }

    private void registerCopy(NFAState original, NFAState copy) {
        if (this.duplicatedStatesMap[original.getId()] == null) {
            this.duplicatedStatesMap[original.getId()] = new ArrayList<NFAState>();
        }
        this.duplicatedStatesMap[original.getId()].add(copy);
        this.states.add(copy);
        assert (this.states.get(copy.getId()) == copy);
    }

    private static final class PathElement {
        private final NFAStateTransition transition;
        private int i = 0;

        private PathElement(NFAStateTransition transition) {
            this.transition = transition;
        }

        public NFAStateTransition getTransition() {
            return this.transition;
        }

        public boolean hasNextTransition() {
            return this.i < this.transition.getTarget().getNext().length;
        }

        public NFAStateTransition getNextTransition() {
            return this.transition.getTarget().getNext()[this.i++];
        }
    }
}

