/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public class BackReference
extends Term {
    private final int groupNr;

    BackReference(int groupNr) {
        this.groupNr = groupNr;
    }

    private BackReference(BackReference copy) {
        super(copy);
        this.groupNr = copy.groupNr;
    }

    @Override
    public BackReference copy(RegexAST ast, boolean recursive) {
        return ast.register(new BackReference(this));
    }

    public int getGroupNr() {
        return this.groupNr;
    }

    @Override
    public boolean equalsSemantic(RegexASTNode obj, boolean ignoreQuantifier) {
        return obj instanceof BackReference && ((BackReference)obj).groupNr == this.groupNr && (ignoreQuantifier || this.quantifierEquals((BackReference)obj));
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "\\" + this.groupNr + this.quantifierToString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return this.toJson("BackReference").append(Json.prop("groupNr", this.groupNr));
    }
}

