/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CharSet;
import com.oracle.truffle.regex.tregex.buffer.CharArrayBuffer;
import com.oracle.truffle.regex.tregex.nfa.ASTNodeSet;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

public class CharacterClass
extends Term {
    private CharSet charSet;
    private ASTNodeSet<Group> lookBehindEntries;

    CharacterClass(CharSet charSet) {
        this.charSet = charSet;
    }

    private CharacterClass(CharacterClass copy) {
        super(copy);
        this.charSet = copy.charSet;
    }

    @Override
    public CharacterClass copy(RegexAST ast, boolean recursive) {
        return ast.register(new CharacterClass(this));
    }

    @Override
    public Sequence getParent() {
        return (Sequence)super.getParent();
    }

    public CharSet getCharSet() {
        return this.charSet;
    }

    public void setCharSet(CharSet charSet) {
        this.charSet = charSet;
    }

    public boolean wasSingleChar() {
        return this.isFlagSet((short)512);
    }

    public void setWasSingleChar() {
        this.setWasSingleChar(true);
    }

    public void setWasSingleChar(boolean value) {
        this.setFlag((short)512, value);
    }

    public void addLookBehindEntry(RegexAST ast, Group lookBehindEntry) {
        if (this.lookBehindEntries == null) {
            this.lookBehindEntries = new ASTNodeSet(ast);
        }
        this.lookBehindEntries.add(lookBehindEntry);
    }

    public boolean hasLookBehindEntries() {
        return this.lookBehindEntries != null;
    }

    public Set<Group> getLookBehindEntries() {
        if (this.lookBehindEntries == null) {
            return Collections.emptySet();
        }
        return this.lookBehindEntries;
    }

    public void extractSingleChar(CharArrayBuffer literal, CharArrayBuffer mask) {
        CharSet c = this.charSet;
        char c1 = (char)c.getLo(0);
        if (c.matches2CharsWith1BitDifference()) {
            int c2 = c.size() == 1 ? c.getHi(0) : c.getLo(1);
            literal.add((char)(c1 | c2));
            mask.add((char)(c1 ^ c2));
        } else {
            assert (c.matchesSingleChar());
            literal.add(c1);
            mask.add('\u0000');
        }
    }

    public void extractSingleChar(char[] literal, char[] mask, int i) {
        CharSet c = this.charSet;
        char c1 = (char)c.getLo(0);
        if (c.matches2CharsWith1BitDifference()) {
            int c2 = c.size() == 1 ? c.getHi(0) : c.getLo(1);
            literal[i] = (char)(c1 | c2);
            mask[i] = (char)(c1 ^ c2);
        } else {
            assert (c.matchesSingleChar());
            literal[i] = c1;
            mask[i] = '\u0000';
        }
    }

    @Override
    public boolean equalsSemantic(RegexASTNode obj, boolean ignoreQuantifier) {
        return obj instanceof CharacterClass && ((CharacterClass)obj).getCharSet().equals(this.charSet) && (ignoreQuantifier || this.quantifierEquals((CharacterClass)obj));
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.charSet.toString() + this.quantifierToString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        JsonObject json = this.toJson("CharacterClass").append(Json.prop("charSet", this.charSet));
        if (this.lookBehindEntries != null) {
            json.append(Json.prop("lookBehindEntries", this.lookBehindEntries.stream().map(RegexASTNode::astNodeId).collect(Collectors.toList())));
        }
        return json;
    }
}

