/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser.ast;

import com.oracle.truffle.regex.tregex.automaton.IndexedState;
import com.oracle.truffle.regex.tregex.parser.ast.LookAheadAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public abstract class RegexASTNode
implements IndexedState,
JsonConvertible {
    private static final short FLAG_PREFIX = 1;
    private static final short FLAG_DEAD = 2;
    private static final short FLAG_CARET = 4;
    private static final short FLAG_DOLLAR = 8;
    protected static final short FLAG_GROUP_LOOP = 16;
    protected static final short FLAG_GROUP_EXPANDED_QUANTIFIER = 32;
    protected static final short FLAG_LOOK_AROUND_NEGATED = 64;
    protected static final short FLAG_EMPTY_GUARD = 128;
    protected static final short FLAG_HAS_LOOPS = 256;
    protected static final short FLAG_CHARACTER_CLASS_WAS_SINGLE_CHAR = 512;
    private short id = (short)-1;
    private RegexASTNode parent;
    private short flags;
    private short minPath = 0;
    private short maxPath = 0;

    protected RegexASTNode() {
    }

    protected RegexASTNode(RegexASTNode copy) {
        this.flags = copy.flags;
        this.minPath = copy.minPath;
        this.maxPath = copy.maxPath;
    }

    public abstract RegexASTNode copy(RegexAST var1, boolean var2);

    public abstract boolean equalsSemantic(RegexASTNode var1);

    public boolean idInitialized() {
        return this.id >= 0;
    }

    @Override
    public short getId() {
        assert (this.idInitialized());
        return this.id;
    }

    public void setId(int id) {
        assert (!this.idInitialized());
        assert (id <= 4000);
        this.id = (short)id;
    }

    public RegexASTNode getParent() {
        return this.parent;
    }

    public void setParent(RegexASTNode parent) {
        this.parent = parent;
    }

    protected boolean isFlagSet(short flag) {
        return (this.flags & flag) != 0;
    }

    protected void setFlag(short flag) {
        this.setFlag(flag, true);
    }

    protected void setFlag(short flag, boolean value) {
        this.flags = value ? (short)(this.flags | flag) : (short)(this.flags & ~flag);
    }

    public void markAsDead() {
        this.setFlag((short)2);
    }

    public boolean isDead() {
        return this.isFlagSet((short)2);
    }

    public boolean isPrefix() {
        return this.isFlagSet((short)1);
    }

    public void setPrefix() {
        this.setFlag((short)1);
    }

    public boolean startsWithCaret() {
        return this.isFlagSet((short)4);
    }

    public void setStartsWithCaret() {
        this.setStartsWithCaret(true);
    }

    public void setStartsWithCaret(boolean startsWithCaret) {
        this.setFlag((short)4, startsWithCaret);
    }

    public boolean endsWithDollar() {
        return this.isFlagSet((short)8);
    }

    public void setEndsWithDollar() {
        this.setEndsWithDollar(true);
    }

    public void setEndsWithDollar(boolean endsWithDollar) {
        this.setFlag((short)8, endsWithDollar);
    }

    public void setHasLoops() {
        this.setHasLoops(true);
    }

    public void setHasLoops(boolean hasLoops) {
        this.setFlag((short)256, hasLoops);
    }

    public boolean hasLoops() {
        return this.isFlagSet((short)256);
    }

    public boolean hasEmptyGuard() {
        return this.isFlagSet((short)128);
    }

    public void setEmptyGuard(boolean emptyGuard) {
        this.setFlag((short)128, emptyGuard);
    }

    public int getMinPath() {
        return this.minPath;
    }

    public void setMinPath(int n) {
        this.minPath = (short)n;
    }

    public void incMinPath() {
        this.incMinPath(1);
    }

    public void incMinPath(int n) {
        this.minPath = (short)(this.minPath + n);
    }

    public int getMaxPath() {
        return this.maxPath;
    }

    public void setMaxPath(int n) {
        this.maxPath = (short)n;
    }

    public void incMaxPath() {
        this.incMaxPath(1);
    }

    public void incMaxPath(int n) {
        this.maxPath = (short)(this.maxPath + n);
    }

    public abstract RegexASTSubtreeRootNode getSubTreeParent();

    public boolean isInLookBehindAssertion() {
        return this.getSubTreeParent() instanceof LookBehindAssertion;
    }

    public boolean isInLookAheadAssertion() {
        return this.getSubTreeParent() instanceof LookAheadAssertion;
    }

    public String toStringWithID() {
        return String.format("%d (%s)", this.id, this.toString());
    }

    protected static JsonValue astNodeId(RegexASTNode astNode) {
        return astNode == null ? Json.nullValue() : Json.val(astNode.id);
    }

    protected JsonObject toJson(String typeName) {
        return Json.obj(Json.prop("id", this.id), Json.prop("type", typeName), Json.prop("parent", RegexASTNode.astNodeId(this.parent)), Json.prop("minPath", this.minPath), Json.prop("isPrefix", this.isPrefix()), Json.prop("isDead", this.isDead()));
    }
}

