/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.menu;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.modules.git.ui.branch.CherryPickAction;
import org.netbeans.modules.git.ui.branch.CreateBranchAction;
import org.netbeans.modules.git.ui.branch.SetTrackingAction;
import org.netbeans.modules.git.ui.checkout.SwitchBranchAction;
import org.netbeans.modules.git.ui.menu.Bundle;
import org.netbeans.modules.git.ui.menu.DynamicMenu;
import org.netbeans.modules.git.ui.merge.MergeRevisionAction;
import org.netbeans.modules.git.ui.rebase.RebaseAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.tag.CreateTagAction;
import org.netbeans.modules.git.ui.tag.ManageTagsAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;

public final class BranchMenu
extends DynamicMenu {
    private final VCSAnnotator.ActionDestination dest;
    private final Lookup lkp;
    private final VCSContext ctx;

    public BranchMenu(VCSAnnotator.ActionDestination dest, Lookup lkp, VCSContext ctx) {
        super(dest.equals((Object)VCSAnnotator.ActionDestination.MainMenu) ? Bundle.CTL_MenuItem_BranchMenu() : Bundle.CTL_MenuItem_BranchMenu_popup());
        this.dest = dest;
        this.lkp = lkp;
        this.ctx = ctx;
    }

    @Override
    protected JMenu createMenu() {
        JMenu menu = new JMenu(this);
        if (this.dest.equals((Object)VCSAnnotator.ActionDestination.MainMenu)) {
            JMenuItem item = new JMenuItem();
            SystemAction action = SystemAction.get(CreateBranchAction.class);
            Utils.setAcceleratorBindings((String)"Actions/Git/", (Action[])new Action[]{action});
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            menu.add(item);
            item = new JMenuItem();
            action = SystemAction.get(SwitchBranchAction.class);
            Utils.setAcceleratorBindings((String)"Actions/Git/", (Action[])new Action[]{action});
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            menu.add(item);
            item = new JMenuItem();
            action = SystemAction.get(SetTrackingAction.class);
            Utils.setAcceleratorBindings((String)"Actions/Git/", (Action[])new Action[]{action});
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            menu.add(item);
            menu.addSeparator();
            item = new JMenuItem();
            action = SystemAction.get(CreateTagAction.class);
            Utils.setAcceleratorBindings((String)"Actions/Git/", (Action[])new Action[]{action});
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            menu.add(item);
            item = new JMenuItem();
            action = SystemAction.get(ManageTagsAction.class);
            Utils.setAcceleratorBindings((String)"Actions/Git/", (Action[])new Action[]{action});
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            menu.add(item);
            menu.addSeparator();
            item = new JMenuItem();
            action = SystemAction.get(MergeRevisionAction.class);
            Utils.setAcceleratorBindings((String)"Actions/Git/", (Action[])new Action[]{action});
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            menu.add(item);
            item = new JMenuItem();
            action = SystemAction.get(RebaseAction.class);
            Utils.setAcceleratorBindings((String)"Actions/Git/", (Action[])new Action[]{action});
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            menu.add(item);
            item = new JMenuItem();
            action = SystemAction.get(CherryPickAction.class);
            Utils.setAcceleratorBindings((String)"Actions/Git/", (Action[])new Action[]{action});
            Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
            menu.add(item);
        } else {
            JMenuItem item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CreateBranchAction.class), (String)NbBundle.getMessage(CreateBranchAction.class, (String)"LBL_CreateBranchAction_PopupName"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(SwitchBranchAction.class), (String)NbBundle.getMessage(SwitchBranchAction.class, (String)"LBL_SwitchBranchAction_PopupName"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            if (this.ctx != null) {
                File repositoryRoot = null;
                Set<File> repositoryRoots = GitUtils.getRepositoryRoots(this.ctx);
                if (repositoryRoots.size() == 1) {
                    repositoryRoot = repositoryRoots.iterator().next();
                }
                if (repositoryRoot != null) {
                    RepositoryInfo info = RepositoryInfo.getInstance(repositoryRoot);
                    GitBranch branch = info.getActiveBranch();
                    List recentlySwitched = Utils.getStringList((Preferences)NbPreferences.forModule(BranchMenu.class), (String)("recentlySwitchedBranches" + repositoryRoot.getAbsolutePath()));
                    int index = 0;
                    for (String recentBranch : recentlySwitched) {
                        if (recentBranch.equals(branch.getName())) continue;
                        menu.add(new SwitchBranchAction.KnownBranchAction(recentBranch, this.ctx));
                        if (++index <= 2) continue;
                        break;
                    }
                }
            }
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(SetTrackingAction.class), (String)NbBundle.getMessage(SetTrackingAction.class, (String)"LBL_SetTrackingAction_PopupName"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            menu.addSeparator();
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CreateTagAction.class), (String)NbBundle.getMessage(CreateTagAction.class, (String)"LBL_CreateTagAction_PopupName"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(ManageTagsAction.class), (String)NbBundle.getMessage(ManageTagsAction.class, (String)"LBL_ManageTagsAction_PopupName"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            menu.addSeparator();
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(MergeRevisionAction.class), (String)NbBundle.getMessage(MergeRevisionAction.class, (String)"LBL_MergeRevisionAction_PopupName"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(RebaseAction.class), (String)NbBundle.getMessage(RebaseAction.class, (String)"LBL_RebaseAction_PopupName"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CherryPickAction.class), (String)NbBundle.getMessage(CherryPickAction.class, (String)"LBL_CherryPickAction_PopupName"), (Lookup)this.lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        }
        return menu;
    }
}

