/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class AbstractUtil {
    private boolean loggable;
    private boolean loggableInit = false;
    private ResourceBundle bundle;

    public static boolean equals(Object a, Object b) {
        if (a != null) {
            return a.equals(b);
        }
        return a == b;
    }

    public final void debug(String message, Throwable ex) {
        if (this.isLoggable()) {
            System.err.println("[org.netbeans.tax] " + message);
            if (ex != null) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public final void debug(String message) {
        this.debug(message, null);
    }

    public final void debug(Throwable ex) {
        this.debug(ex.getMessage(), ex);
    }

    public final synchronized boolean isLoggable() {
        if (!this.loggableInit) {
            this.loggable = Boolean.getBoolean("org.netbeans.tax");
            this.loggableInit = true;
        }
        return this.loggable;
    }

    protected final synchronized ResourceBundle getBundle() {
        return ResourceBundle.getBundle(this.getClass().getName().replaceFirst("\\.[^.]+$", ".Bundle"));
    }

    public final String getString(String key) {
        return this.getBundle().getString(key);
    }

    public final String getString(String key, Object param) {
        return MessageFormat.format(this.getBundle().getString(key), param);
    }

    public final char getChar(String key) {
        return this.getString(key).charAt(0);
    }
}

