/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.encapsulation;

import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class ReturnEncapsulation {
    private static final String COLLECTION = "java.util.Collection";
    private static final String MAP = "java.util.Map";
    private static final String DATE = "java.util.Date";
    private static final String CALENDAR = "java.util.Calendar";
    private static final String A_OBJ = "java.lang.Object[]";
    private static final String A_BOOL = "boolean[]";
    private static final String A_BYTE = "byte[]";
    private static final String A_CHAR = "char[]";
    private static final String A_SHORT = "short[]";
    private static final String A_INT = "int[]";
    private static final String A_LONG = "long[]";
    private static final String A_FLOAT = "float[]";
    private static final String A_DOUBLE = "double[]";
    private static final Iterable<? extends String> UNMODIFIABLE = Arrays.asList("java.util.Collections.<$T$>emptySet()", "java.util.Collections.<$T$>emptyList()", "java.util.Collections.<$T$>emptyMap()", "java.util.Collections.EMPTY_SET", "java.util.Collections.EMPTY_LIST", "java.util.Collections.EMPTY_MAP", "java.util.Collections.<$T$>singleton($any)", "java.util.Collections.<$T$>singletonList($any)", "java.util.Collections.<$T$>singletonMap($any)", "java.util.Collections.<$T$>unmodifiableCollection($any)", "java.util.Collections.<$T$>unmodifiableList($any)", "java.util.Collections.<$T$>unmodifiableSet($any)", "java.util.Collections.<$T$>unmodifiableSortedSet($any)", "java.util.Collections.<$T$>unmodifiableMap($any)", "java.util.Collections.<$T$>unmodifiableSortedMap($any)", "java.util.Arrays.<$T$>asList($any$)");

    public static ErrorDescription collection(HintContext ctx) {
        assert (ctx != null);
        return ReturnEncapsulation.create(ctx, NbBundle.getMessage(ReturnEncapsulation.class, (String)"TXT_ReturnCollection"), "ReturnOfCollectionOrArrayField", new FixProvider());
    }

    public static ErrorDescription array(HintContext ctx) {
        assert (ctx != null);
        return ReturnEncapsulation.create(ctx, NbBundle.getMessage(ReturnEncapsulation.class, (String)"TXT_ReturnArray"), "ReturnOfCollectionOrArrayField", new FixProvider[0]);
    }

    public static ErrorDescription date(HintContext ctx) {
        assert (ctx != null);
        return ReturnEncapsulation.create(ctx, NbBundle.getMessage(ReturnEncapsulation.class, (String)"TXT_ReturnDate"), "ReturnOfDateField", new FixProvider[0]);
    }

    private static ErrorDescription create(HintContext ctx, String description, String suppressWarnings, FixProvider ... providers) {
        Element enclMethod;
        TreePath decl;
        assert (ctx != null);
        assert (suppressWarnings != null);
        CompilationInfo info = ctx.getInfo();
        TreePath tp = ctx.getPath();
        TreePath exprPath = (TreePath)ctx.getVariables().get("$expr");
        Element exprElement = info.getTrees().getElement(exprPath);
        TypeMirror exprType = info.getTrees().getTypeMirror(exprPath);
        if (exprElement == null || !Utilities.isValidType(exprType) || exprElement.getKind() != ElementKind.FIELD) {
            return null;
        }
        if (exprElement.getModifiers().contains((Object)Modifier.FINAL) && (decl = ctx.getInfo().getTrees().getPath(exprElement)) != null && decl.getLeaf().getKind() == Tree.Kind.VARIABLE && ((VariableTree)decl.getLeaf()).getInitializer() != null) {
            TreePath init = new TreePath(decl, ((VariableTree)decl.getLeaf()).getInitializer());
            for (String string : UNMODIFIABLE) {
                if (!MatcherUtilities.matches((HintContext)ctx, (TreePath)init, (String)string)) continue;
                return null;
            }
        }
        if ((enclMethod = ReturnEncapsulation.getElementOrNull(info, ReturnEncapsulation.findEnclosingMethod(tp))) == null || enclMethod.getEnclosingElement() != exprElement.getEnclosingElement()) {
            return null;
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>(providers.length + 1);
        for (int i = 0; i < providers.length; ++i) {
            Fix fix = providers[i].fixFor(ctx, (ExecutableElement)enclMethod, exprPath);
            if (fix == null) continue;
            fixes.add(fix);
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)tp, (String)description, (Fix[])fixes.toArray(new Fix[0]));
    }

    private static final TreePath findEnclosingMethod(TreePath tp) {
        while (tp != null && tp.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (tp.getLeaf().getKind() == Tree.Kind.METHOD) {
                return tp;
            }
            tp = tp.getParentPath();
        }
        return null;
    }

    private static Element getElementOrNull(CompilationInfo info, TreePath path) {
        return path == null ? null : info.getTrees().getElement(path);
    }

    private static class FixProvider {
        private static final Map<String, String> TO_UNMODIFIABLE = new LinkedHashMap<String, String>();

        private FixProvider() {
        }

        public Fix fixFor(HintContext ctx, ExecutableElement enclMethod, TreePath tp) {
            CompilationInfo info = ctx.getInfo();
            assert (info != null);
            assert (tp != null);
            Element fe = info.getTrees().getElement(tp);
            if (fe == null) {
                return null;
            }
            String field = fe.getSimpleName().toString();
            Types types = info.getTypes();
            Elements elements = info.getElements();
            TypeMirror returnTypeEr = types.erasure(enclMethod.getReturnType());
            for (Map.Entry<String, String> e : TO_UNMODIFIABLE.entrySet()) {
                TypeElement el = elements.getTypeElement(e.getKey());
                if (el == null || !types.isSameType(returnTypeEr, types.erasure(el.asType()))) continue;
                return JavaFixUtilities.rewriteFix((HintContext)ctx, (String)NbBundle.getMessage(ReturnEncapsulation.class, (String)"FIX_ReplaceWithUC", (Object)e.getValue(), (Object)field), (TreePath)tp, (String)("java.util.Collections." + e.getValue() + "($expr)"));
            }
            return null;
        }

        static {
            TO_UNMODIFIABLE.put("java.util.SortedMap", "unmodifiableSortedMap");
            TO_UNMODIFIABLE.put("java.util.SortedSet", "unmodifiableSortedSet");
            TO_UNMODIFIABLE.put(ReturnEncapsulation.MAP, "unmodifiableMap");
            TO_UNMODIFIABLE.put("java.util.Set", "unmodifiableSet");
            TO_UNMODIFIABLE.put("java.util.List", "unmodifiableList");
            TO_UNMODIFIABLE.put(ReturnEncapsulation.COLLECTION, "unmodifiableCollection");
        }
    }
}

