/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;

public class ArrayAccess
implements ErrorRule<Void> {
    private static final Set<String> CODES = new HashSet<String>(Arrays.asList("compiler.err.array.req.but.found"));
    private static final Set<Tree.Kind> CANNOT_HANDLE_PARENTS = EnumSet.of(Tree.Kind.MULTIPLY_ASSIGNMENT, new Tree.Kind[]{Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT});

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (treePath.getLeaf().getKind() != Tree.Kind.ARRAY_ACCESS) {
            return Collections.emptyList();
        }
        ArrayAccessTree aa = (ArrayAccessTree)treePath.getLeaf();
        TypeMirror onType = info.getTrees().getTypeMirror(new TreePath(treePath, aa.getExpression()));
        boolean list = ArrayAccess.isSubType(info, onType, "java.util.List");
        boolean map = ArrayAccess.isSubType(info, onType, "java.util.Map");
        if (list || map) {
            Tree.Kind parentKind = treePath.getParentPath().getLeaf().getKind();
            if (CANNOT_HANDLE_PARENTS.contains((Object)parentKind)) {
                return null;
            }
            return Collections.singletonList(new ConvertFromArrayAccess(info, treePath, map, parentKind == Tree.Kind.ASSIGNMENT).toEditorFix());
        }
        return Collections.emptyList();
    }

    private static boolean isSubType(CompilationInfo info, TypeMirror onType, String expectedType) {
        if (!Utilities.isValidType(onType)) {
            return false;
        }
        TypeElement expectedTypeElement = info.getElements().getTypeElement(expectedType);
        if (expectedTypeElement == null) {
            return false;
        }
        TypeMirror expectedTypeMirror = expectedTypeElement.asType();
        return info.getTypes().isSubtype(info.getTypes().erasure(onType), info.getTypes().erasure(expectedTypeMirror));
    }

    public String getId() {
        return ArrayAccess.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_AccessError();
    }

    public void cancel() {
    }

    private static final class ConvertFromArrayAccess
    extends JavaFix {
        private final boolean map;
        private final boolean assignment;

        public ConvertFromArrayAccess(CompilationInfo info, TreePath tp, boolean map, boolean assignment) {
            super(info, tp);
            this.map = map;
            this.assignment = assignment;
        }

        protected String getText() {
            return this.map ? (this.assignment ? Bundle.FIX_UseMapPut() : Bundle.FIX_UseMapGet()) : (this.assignment ? Bundle.FIX_UseListSet() : Bundle.FIX_UseListGet());
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            ArrayAccessTree aa = (ArrayAccessTree)ctx.getPath().getLeaf();
            TreeMaker make = ctx.getWorkingCopy().getTreeMaker();
            if (this.assignment) {
                AssignmentTree at = (AssignmentTree)ctx.getPath().getParentPath().getLeaf();
                ctx.getWorkingCopy().rewrite((Tree)at, (Tree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(aa.getExpression(), (CharSequence)(this.map ? " put" : "set")), Arrays.asList(aa.getIndex(), at.getExpression())));
            } else {
                ctx.getWorkingCopy().rewrite((Tree)aa, (Tree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.MemberSelect(aa.getExpression(), (CharSequence)"get"), Collections.singletonList(aa.getIndex())));
            }
        }
    }
}

