/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.netbeans.modules.javaee.specs.support.api.JaxRpc;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

public class Hk2JaxRpcStack
implements WSStackImplementation<JaxRpc> {
    private static final String[] METRO_LIBRARIES = new String[]{"webservices(|-osgi).jar"};
    private static final String PF_MODULES_DIR_NAME = "modules";
    private String gfRootStr;
    private JaxRpc jaxRpc;

    public Hk2JaxRpcStack(String gfRootStr) {
        this.gfRootStr = gfRootStr;
        this.jaxRpc = new JaxRpc();
    }

    public JaxRpc get() {
        return this.jaxRpc;
    }

    public WSStackVersion getVersion() {
        return WSStackVersion.valueOf((int)1, (int)1, (int)3, (int)0);
    }

    public WSTool getWSTool(WSStack.Tool toolId) {
        if (toolId == JaxRpc.Tool.WCOMPILE && this.isMetroInstalled()) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxRpcTool(JaxRpc.Tool.WCOMPILE));
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        return feature == JaxRpc.Feature.JSR109 && this.isMetroInstalled();
    }

    protected boolean isMetroInstalled() {
        File f = this.getJarName(this.gfRootStr, METRO_LIBRARIES[0]);
        return f != null && f.exists();
    }

    protected File getJarName(String glassfishInstallRoot, String jarNamePattern) {
        File[] candidates;
        File modulesDir = new File(glassfishInstallRoot + File.separatorChar + PF_MODULES_DIR_NAME);
        int subindex = jarNamePattern.lastIndexOf("/");
        if (subindex != -1) {
            String subdir = jarNamePattern.substring(0, subindex);
            jarNamePattern = jarNamePattern.substring(subindex + 1);
            modulesDir = new File(modulesDir, subdir);
        }
        if ((candidates = modulesDir.listFiles(new VersionFilter(jarNamePattern))) != null && candidates.length > 0) {
            return candidates[0];
        }
        return null;
    }

    private static class VersionFilter
    implements FileFilter {
        private final Pattern pattern;

        public VersionFilter(String namePattern) {
            this.pattern = Pattern.compile(namePattern);
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }

    protected class JaxRpcTool
    implements WSToolImplementation {
        JaxRpc.Tool tool;

        JaxRpcTool(JaxRpc.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            ArrayList<URL> cPath = new ArrayList<URL>();
            if (Hk2JaxRpcStack.this.isMetroInstalled()) {
                for (String entry : METRO_LIBRARIES) {
                    File f = Hk2JaxRpcStack.this.getJarName(Hk2JaxRpcStack.this.gfRootStr, entry);
                    if (f == null || !f.exists()) continue;
                    try {
                        cPath.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            return cPath.toArray(new URL[cPath.size()]);
        }
    }
}

