/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.ReflectBuiltins;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsExtensibleNode;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.access.ToPropertyDescriptorNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ReflectBuiltins.class)
public final class ReflectBuiltinsFactory {

    @GeneratedBy(value=ReflectBuiltins.ReflectSetPrototypeOfNode.class)
    public static final class ReflectSetPrototypeOfNodeGen
    extends ReflectBuiltins.ReflectSetPrototypeOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private ReflectSetPrototypeOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.reflectSetPrototypeOf(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.reflectSetPrototypeOf(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "reflectSetPrototypeOf";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectSetPrototypeOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectSetPrototypeOfNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectSetNode.class)
    public static final class ReflectSetNodeGen
    extends ReflectBuiltins.ReflectSetNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToPropertyKeyNode reflectSetProxy_toPropertyKeyNode_;
        @Node.Child
        private JSToBooleanNode reflectSetProxy_toBooleanNode_;
        @Node.Child
        private JSToPropertyKeyNode reflectSetModuleNamespace_toPropertyKeyNode_;
        @Node.Child
        private JSToPropertyKeyNode reflectSet_toPropertyKeyNode_;

        private ReflectSetNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[])arguments0Value_;
                if ((state & 1) != 0 && ReflectBuiltins.ReflectSetNode.isProxy(arguments0Value__)) {
                    return this.reflectSetProxy(arguments0Value__, this.reflectSetProxy_toPropertyKeyNode_, this.reflectSetProxy_toBooleanNode_);
                }
                if ((state & 2) != 0 && ReflectBuiltins.ReflectSetNode.isModuleNamespace(arguments0Value__)) {
                    return this.reflectSetModuleNamespace(arguments0Value__, this.reflectSetModuleNamespace_toPropertyKeyNode_);
                }
                if ((state & 4) != 0 && !ReflectBuiltins.ReflectSetNode.isProxy(arguments0Value__) && !ReflectBuiltins.ReflectSetNode.isModuleNamespace(arguments0Value__)) {
                    return this.reflectSet(arguments0Value__, this.reflectSet_toPropertyKeyNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[])arguments0Value_;
                if ((state & 1) != 0 && ReflectBuiltins.ReflectSetNode.isProxy(arguments0Value__)) {
                    return this.reflectSetProxy(arguments0Value__, this.reflectSetProxy_toPropertyKeyNode_, this.reflectSetProxy_toBooleanNode_);
                }
                if ((state & 2) != 0 && ReflectBuiltins.ReflectSetNode.isModuleNamespace(arguments0Value__)) {
                    return this.reflectSetModuleNamespace(arguments0Value__, this.reflectSetModuleNamespace_toPropertyKeyNode_);
                }
                if ((state & 4) != 0 && !ReflectBuiltins.ReflectSetNode.isProxy(arguments0Value__) && !ReflectBuiltins.ReflectSetNode.isModuleNamespace(arguments0Value__)) {
                    return this.reflectSet(arguments0Value__, this.reflectSet_toPropertyKeyNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        private boolean executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arguments0Value instanceof Object[]) {
                    Object[] arguments0Value_ = (Object[])arguments0Value;
                    if (ReflectBuiltins.ReflectSetNode.isProxy(arguments0Value_)) {
                        this.reflectSetProxy_toPropertyKeyNode_ = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                        this.reflectSetProxy_toBooleanNode_ = (JSToBooleanNode)super.insert((Node)JSToBooleanNode.create());
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.reflectSetProxy(arguments0Value_, this.reflectSetProxy_toPropertyKeyNode_, this.reflectSetProxy_toBooleanNode_);
                        return bl;
                    }
                    if (ReflectBuiltins.ReflectSetNode.isModuleNamespace(arguments0Value_)) {
                        this.reflectSetModuleNamespace_toPropertyKeyNode_ = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.reflectSetModuleNamespace(arguments0Value_, this.reflectSetModuleNamespace_toPropertyKeyNode_);
                        return bl;
                    }
                    if (!ReflectBuiltins.ReflectSetNode.isProxy(arguments0Value_) && !ReflectBuiltins.ReflectSetNode.isModuleNamespace(arguments0Value_)) {
                        this.reflectSet_toPropertyKeyNode_ = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.reflectSet(arguments0Value_, this.reflectSet_toPropertyKeyNode_);
                        return bl;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<JavaScriptBaseNode>> cached;
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "reflectSetProxy";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.reflectSetProxy_toPropertyKeyNode_, this.reflectSetProxy_toBooleanNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "reflectSetModuleNamespace";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.reflectSetModuleNamespace_toPropertyKeyNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "reflectSet";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.reflectSet_toPropertyKeyNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectSetNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectSetNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectPreventExtensionsNode.class)
    public static final class ReflectPreventExtensionsNodeGen
    extends ReflectBuiltins.ReflectPreventExtensionsNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ReflectPreventExtensionsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.reflectPreventExtensions(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.reflectPreventExtensions(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "reflectPreventExtensions";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectPreventExtensionsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectPreventExtensionsNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectOwnKeysNode.class)
    public static final class ReflectOwnKeysNodeGen
    extends ReflectBuiltins.ReflectOwnKeysNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ReflectOwnKeysNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.reflectOwnKeys(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "reflectOwnKeys";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectOwnKeysNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectOwnKeysNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectIsExtensibleNode.class)
    public static final class ReflectIsExtensibleNodeGen
    extends ReflectBuiltins.ReflectIsExtensibleNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private IsExtensibleNode isExtensibleNode_;

        private ReflectIsExtensibleNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0) {
                return this.reflectIsExtensible(arguments0Value_, this.isExtensibleNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0) {
                return this.reflectIsExtensible(arguments0Value_, this.isExtensibleNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.isExtensibleNode_ = (IsExtensibleNode)super.insert((Node)IsExtensibleNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.reflectIsExtensible(arguments0Value, this.isExtensibleNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "reflectIsExtensible";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<IsExtensibleNode>> cached = new ArrayList<List<IsExtensibleNode>>();
                cached.add(Arrays.asList(this.isExtensibleNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectIsExtensibleNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectIsExtensibleNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectHasNode.class)
    public static final class ReflectHasNodeGen
    extends ReflectBuiltins.ReflectHasNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode_;

        private ReflectHasNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                return this.reflectHas(arguments0Value_, arguments1Value_, this.toPropertyKeyNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                return this.reflectHas(arguments0Value_, arguments1Value_, this.toPropertyKeyNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toPropertyKeyNode_ = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.reflectHas(arguments0Value, arguments1Value, this.toPropertyKeyNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "reflectHas";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToPropertyKeyNode>> cached = new ArrayList<List<JSToPropertyKeyNode>>();
                cached.add(Arrays.asList(this.toPropertyKeyNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectHasNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectHasNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectGetPrototypeOfNode.class)
    public static final class ReflectGetPrototypeOfNodeGen
    extends ReflectBuiltins.ReflectGetPrototypeOfNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;

        private ReflectGetPrototypeOfNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.reflectGetPrototypeOf(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "reflectGetPrototypeOf";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectGetPrototypeOfNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectGetPrototypeOfNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectGetOwnPropertyDescriptorNode.class)
    public static final class ReflectGetOwnPropertyDescriptorNodeGen
    extends ReflectBuiltins.ReflectGetOwnPropertyDescriptorNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode_;
        @Node.Child
        private JSGetOwnPropertyNode getOwnPropertyNode_;

        private ReflectGetOwnPropertyDescriptorNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                return this.reflectGetOwnPropertyDescriptor(arguments0Value_, arguments1Value_, this.toPropertyKeyNode_, this.getOwnPropertyNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicObject executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toPropertyKeyNode_ = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                this.getOwnPropertyNode_ = (JSGetOwnPropertyNode)super.insert((Node)JSGetOwnPropertyNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.reflectGetOwnPropertyDescriptor(arguments0Value, arguments1Value, this.toPropertyKeyNode_, this.getOwnPropertyNode_);
                return dynamicObject;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "reflectGetOwnPropertyDescriptor";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.toPropertyKeyNode_, this.getOwnPropertyNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectGetOwnPropertyDescriptorNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectGetOwnPropertyDescriptorNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectGetNode.class)
    public static final class ReflectGetNodeGen
    extends ReflectBuiltins.ReflectGetNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToPropertyKeyNode object_toPropertyKeyNode_;
        @CompilerDirectives.CompilationFinal
        private JSClassProfile object_classProfile_;

        private ReflectGetNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[])arguments0Value_;
                if ((state & 1) != 0 && !ReflectBuiltins.ReflectGetNode.targetIsObject(arguments0Value__)) {
                    return this.doNonObject(arguments0Value__);
                }
                if ((state & 2) != 0 && ReflectBuiltins.ReflectGetNode.targetIsObject(arguments0Value__)) {
                    return this.doObject(arguments0Value__, this.object_toPropertyKeyNode_, this.object_classProfile_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (arguments0Value instanceof Object[]) {
                    Object[] arguments0Value_ = (Object[])arguments0Value;
                    if (!ReflectBuiltins.ReflectGetNode.targetIsObject(arguments0Value_)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doNonObject(arguments0Value_);
                        return object;
                    }
                    if (ReflectBuiltins.ReflectGetNode.targetIsObject(arguments0Value_)) {
                        this.object_toPropertyKeyNode_ = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                        this.object_classProfile_ = JSClassProfile.create();
                        this.state_ = state |= 2;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doObject(arguments0Value_, this.object_toPropertyKeyNode_, this.object_classProfile_);
                        return object;
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doNonObject";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doObject";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                ArrayList<List<Cloneable>> cached = new ArrayList<List<Cloneable>>();
                cached.add(Arrays.asList(new Cloneable[]{this.object_toPropertyKeyNode_, this.object_classProfile_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectGetNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectGetNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectDeletePropertyNode.class)
    public static final class ReflectDeletePropertyNodeGen
    extends ReflectBuiltins.ReflectDeletePropertyNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode_;

        private ReflectDeletePropertyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                return this.reflectDeleteProperty(arguments0Value_, arguments1Value_, this.toPropertyKeyNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state != 0) {
                return this.reflectDeleteProperty(arguments0Value_, arguments1Value_, this.toPropertyKeyNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toPropertyKeyNode_ = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.reflectDeleteProperty(arguments0Value, arguments1Value, this.toPropertyKeyNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "reflectDeleteProperty";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToPropertyKeyNode>> cached = new ArrayList<List<JSToPropertyKeyNode>>();
                cached.add(Arrays.asList(this.toPropertyKeyNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectDeletePropertyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectDeletePropertyNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectDefinePropertyNode.class)
    public static final class ReflectDefinePropertyNodeGen
    extends ReflectBuiltins.ReflectDefinePropertyNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode_;
        @Node.Child
        private ToPropertyDescriptorNode toPropertyDescriptorNode_;

        private ReflectDefinePropertyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                return this.reflectDefineProperty(arguments0Value_, arguments1Value_, arguments2Value_, this.toPropertyKeyNode_, this.toPropertyDescriptorNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                return this.reflectDefineProperty(arguments0Value_, arguments1Value_, arguments2Value_, this.toPropertyKeyNode_, this.toPropertyDescriptorNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toPropertyKeyNode_ = (JSToPropertyKeyNode)super.insert((Node)JSToPropertyKeyNode.create());
                this.toPropertyDescriptorNode_ = (ToPropertyDescriptorNode)super.insert((Node)ToPropertyDescriptorNode.create(this.getContext()));
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                boolean bl = this.reflectDefineProperty(arguments0Value, arguments1Value, arguments2Value, this.toPropertyKeyNode_, this.toPropertyDescriptorNode_);
                return bl;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "reflectDefineProperty";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.toPropertyKeyNode_, this.toPropertyDescriptorNode_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectDefinePropertyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectDefinePropertyNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectConstructNode.class)
    public static final class ReflectConstructNodeGen
    extends ReflectBuiltins.ReflectConstructNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;

        private ReflectConstructNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0 && arguments0Value_ instanceof Object[]) {
                Object[] arguments0Value__ = (Object[])arguments0Value_;
                return this.reflectConstruct(arguments0Value__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            int state = this.state_;
            if (arguments0Value instanceof Object[]) {
                Object[] arguments0Value_ = (Object[])arguments0Value;
                this.state_ = state |= 1;
                return this.reflectConstruct(arguments0Value_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "reflectConstruct";
            s[1] = state != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectConstructNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectConstructNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=ReflectBuiltins.ReflectApplyNode.class)
    public static final class ReflectApplyNodeGen
    extends ReflectBuiltins.ReflectApplyNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @Node.Child
        private IsCallableNode isCallable;

        private ReflectApplyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                DynamicObject arguments0Value__;
                if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_) && JSGuards.isJSFunction(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                    return this.applyFunction(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 6) != 0) {
                    if ((state & 2) != 0 && this.isCallable.executeBoolean(arguments0Value_)) {
                        return this.applyCallable(arguments0Value_, arguments1Value_, arguments2Value_, this.isCallable);
                    }
                    if ((state & 4) != 0 && !this.isCallable.executeBoolean(arguments0Value_)) {
                        return ReflectBuiltins.ReflectApplyNode.error(arguments0Value_, arguments1Value_, arguments2Value_, this.isCallable);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            try {
                IsCallableNode error_isCallable__;
                Object applyCallable_isCallable__;
                DynamicObject arguments0Value_;
                if (exclude == 0 && JSTypes.isDynamicObject(arguments0Value) && JSGuards.isJSFunction(arguments0Value_ = (DynamicObject)arguments0Value)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.applyFunction(arguments0Value_, arguments1Value, arguments2Value);
                    return object;
                }
                boolean ApplyCallable_duplicateFound_ = false;
                if ((state & 2) != 0 && this.isCallable.executeBoolean(arguments0Value)) {
                    ApplyCallable_duplicateFound_ = true;
                }
                if (!ApplyCallable_duplicateFound_ && (applyCallable_isCallable__ = (IsCallableNode)super.insert((Node)IsCallableNode.create())).executeBoolean(arguments0Value) && (state & 2) == 0) {
                    if (this.isCallable == null) {
                        this.isCallable = (IsCallableNode)super.insert((Node)applyCallable_isCallable__);
                    }
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFE;
                    this.state_ = state |= 2;
                    ApplyCallable_duplicateFound_ = true;
                }
                if (ApplyCallable_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    applyCallable_isCallable__ = this.applyCallable(arguments0Value, arguments1Value, arguments2Value, this.isCallable);
                    return applyCallable_isCallable__;
                }
                boolean Error_duplicateFound_ = false;
                if ((state & 4) != 0 && !this.isCallable.executeBoolean(arguments0Value)) {
                    Error_duplicateFound_ = true;
                }
                if (!Error_duplicateFound_ && !(error_isCallable__ = (IsCallableNode)super.insert((Node)IsCallableNode.create())).executeBoolean(arguments0Value) && (state & 4) == 0) {
                    if (this.isCallable == null) {
                        this.isCallable = (IsCallableNode)super.insert((Node)error_isCallable__);
                    }
                    this.state_ = state |= 4;
                    Error_duplicateFound_ = true;
                }
                if (Error_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    Object object = ReflectBuiltins.ReflectApplyNode.error(arguments0Value, arguments1Value, arguments2Value, this.isCallable);
                    return object;
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<IsCallableNode>> cached;
            Object[] data = new Object[4];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "applyFunction";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : (exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[1] = s;
            s = new Object[3];
            s[0] = "applyCallable";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<IsCallableNode>>();
                cached.add(Arrays.asList(this.isCallable));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "error";
            if ((state & 4) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.isCallable));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[3] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ReflectBuiltins.ReflectApplyNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new ReflectApplyNodeGen(context, builtin, arguments);
        }
    }
}

