/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.Truncatable;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.instrumentation.JSInputGeneratingNodeWrapper;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSComplementNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import java.util.Set;

@NodeInfo(shortName="~")
public abstract class JSComplementNode
extends JSUnaryNode {
    protected JSComplementNode(JavaScriptNode operand) {
        super(operand);
    }

    public static JSComplementNode create(JavaScriptNode operand) {
        Truncatable.truncate(operand);
        return JSComplementNodeGen.create(JSToNumericNode.create(operand));
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.UnaryOperationTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.UnaryOperationTag.class) && !(this.getOperand() instanceof JSInputGeneratingNodeWrapper)) {
            JSComplementNode materialized = JSComplementNodeGen.create(JSInputGeneratingNodeWrapper.create(this.getOperand()));
            JSComplementNode.transferSourceSectionAddExpressionTag(this, materialized);
            return materialized;
        }
        return this;
    }

    @Specialization
    protected int doInteger(int a) {
        return ~a;
    }

    @Specialization
    protected int doDouble(double a, @Cached(value="create()") JSToInt32Node toInt32Node) {
        return this.doInteger(toInt32Node.executeInt(a));
    }

    @Specialization
    protected BigInt doBigInt(BigInt a) {
        return a.not();
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Number.class;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSComplementNodeGen.create(JSComplementNode.cloneUninitialized(this.getOperand()));
    }
}

