/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser;

import com.oracle.js.parser.ir.Block;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.FunctionNode;
import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ScriptNode;
import com.oracle.truffle.js.nodes.function.FunctionRootNode;
import com.oracle.truffle.js.nodes.function.JSFunctionExpressionNode;
import com.oracle.truffle.js.parser.GraalJSEvaluator;
import com.oracle.truffle.js.parser.GraalJSParserHelper;
import com.oracle.truffle.js.parser.GraalJSTranslator;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class JavaScriptTranslator
extends GraalJSTranslator {
    private final Module moduleNode;
    private ScriptOrModule scriptOrModule;

    private JavaScriptTranslator(NodeFactory factory, JSContext context, Source source, Environment environment, boolean isParentStrict, Module moduleNode) {
        super(factory, context, source, environment, isParentStrict);
        this.moduleNode = moduleNode;
    }

    private JavaScriptTranslator(NodeFactory factory, JSContext context, Source source, Environment environment, boolean isParentStrict) {
        this(factory, context, source, environment, isParentStrict, null);
    }

    public static ScriptNode translateScript(NodeFactory factory, JSContext context, Source source, boolean isParentStrict) {
        return JavaScriptTranslator.translateScript(factory, context, null, source, isParentStrict, false, false);
    }

    public static ScriptNode translateEvalScript(NodeFactory factory, JSContext context, Environment env, Source source, boolean isParentStrict) {
        boolean evalInGlobalScope = env == null || env.getParent() == null || env.getParent().function() != null && env.getParent().function().isGlobal();
        return JavaScriptTranslator.translateScript(factory, context, env, source, isParentStrict, true, evalInGlobalScope);
    }

    public static ScriptNode translateInlineScript(NodeFactory factory, JSContext context, Environment env, Source source, boolean isParentStrict) {
        boolean evalInGlobalScope = env.getParent() == null;
        return JavaScriptTranslator.translateScript(factory, context, env, source, isParentStrict, true, evalInGlobalScope);
    }

    private static ScriptNode translateScript(NodeFactory nodeFactory, JSContext context, Environment env, Source source, boolean isParentStrict, boolean isEval, boolean evalInGlobalScope) {
        FunctionNode parserFunctionNode = GraalJSParserHelper.parseScript(context, source, context.getParserOptions().putStrict(isParentStrict), isEval, evalInGlobalScope);
        Source src = source;
        String explicitURL = parserFunctionNode.getSource().getExplicitURL();
        if (explicitURL != null) {
            src = Source.newBuilder((Source)source).name(explicitURL).internal(source.isInternal() || explicitURL.startsWith("internal:")).build();
        }
        return JavaScriptTranslator.translateFunction(nodeFactory, context, env, src, isParentStrict, parserFunctionNode);
    }

    public static ScriptNode translateFunction(NodeFactory factory, JSContext context, Environment env, Source source, boolean isParentStrict, FunctionNode rootNode) {
        return new JavaScriptTranslator(factory, context, source, env, isParentStrict).translateScript(rootNode);
    }

    public static JavaScriptNode translateExpression(NodeFactory factory, JSContext context, Environment env, Source source, boolean isParentStrict, Expression expression) {
        return new JavaScriptTranslator(factory, context, source, env, isParentStrict).translateExpression(expression);
    }

    public static JSModuleRecord translateModule(NodeFactory factory, JSContext context, Source source, JSModuleLoader moduleLoader) {
        FunctionNode parsed = GraalJSParserHelper.parseModule(context, source, context.getParserOptions().putStrict(true));
        JavaScriptTranslator translator = new JavaScriptTranslator(factory, context, source, null, true, parsed.getModule());
        JSModuleRecord moduleRecord = new JSModuleRecord(parsed.getModule(), context, moduleLoader, source, () -> translator.translateModule(parsed));
        translator.scriptOrModule = moduleRecord;
        return moduleRecord;
    }

    private JSModuleRecord translateModule(FunctionNode functionNode) {
        if (!functionNode.isModule()) {
            throw new IllegalArgumentException("root function node is not a module");
        }
        JSFunctionExpressionNode functionExpression = (JSFunctionExpressionNode)this.transformFunction(functionNode);
        FunctionRootNode functionRoot = functionExpression.getFunctionNode();
        JSModuleRecord moduleRecord = (JSModuleRecord)this.scriptOrModule;
        moduleRecord.setFunctionData(functionRoot.getFunctionData());
        moduleRecord.setFrameDescriptor(functionRoot.getFrameDescriptor());
        return moduleRecord;
    }

    @Override
    protected List<JavaScriptNode> setupModuleEnvironment(FunctionNode functionNode) {
        assert (functionNode.isModule());
        ArrayList<JavaScriptNode> declarations = new ArrayList<JavaScriptNode>();
        GraalJSEvaluator evaluator = (GraalJSEvaluator)this.context.getEvaluator();
        for (Module.ImportEntry importEntry : this.moduleNode.getImportEntries()) {
            JSModuleRecord importedModule = evaluator.hostResolveImportedModule(this.context, this.scriptOrModule, importEntry.getModuleRequest());
            String localName = importEntry.getLocalName();
            if (importEntry.getImportName().equals("*")) {
                assert (functionNode.getBody().getScope().hasSymbol(localName) && functionNode.getBody().getScope().getExistingSymbol(localName).hasBeenDeclared());
                DynamicObject namespace = evaluator.getModuleNamespace(importedModule);
                declarations.add(this.factory.createLazyWriteFrameSlot(localName, this.factory.createConstant(namespace)));
                continue;
            }
            assert (functionNode.getBody().getScope().hasSymbol(localName) && functionNode.getBody().getScope().getExistingSymbol(localName).isImportBinding());
            ExportResolution resolution = evaluator.resolveExport(importedModule, importEntry.getImportName());
            assert (!resolution.isNull() && !resolution.isAmbiguous());
            this.createImportBinding(localName, resolution.getModule(), resolution.getBindingName());
        }
        this.verifyModuleExportedNames();
        declarations.add(this.factory.createSetModuleEnvironment(this.getActiveScriptOrModule()));
        return declarations;
    }

    private void verifyModuleExportedNames() {
        HashSet<String> exportedNames = new HashSet<String>();
        for (Module.ExportEntry exportEntry : this.moduleNode.getLocalExportEntries()) {
            if (exportedNames.add(exportEntry.getExportName())) continue;
            throw Errors.createSyntaxError("Duplicate export");
        }
        for (Module.ExportEntry exportEntry : this.moduleNode.getIndirectExportEntries()) {
            if (exportedNames.add(exportEntry.getExportName())) continue;
            throw Errors.createSyntaxError("Duplicate export");
        }
    }

    @Override
    protected void verifyModuleLocalExports(Block moduleBodyBlock) {
        for (Module.ExportEntry exportEntry : this.moduleNode.getLocalExportEntries()) {
            if (moduleBodyBlock.getScope().hasSymbol(exportEntry.getLocalName())) continue;
            throw Errors.createSyntaxError(String.format("Export specifies undeclared identifier: '%s'", exportEntry.getLocalName()));
        }
    }

    @Override
    protected JavaScriptNode getActiveScriptOrModule() {
        if (this.scriptOrModule == null) {
            assert (this.moduleNode == null);
            this.scriptOrModule = new ScriptOrModule(this.context, this.source);
        }
        return this.factory.createConstant(this.scriptOrModule);
    }

    @Override
    protected GraalJSTranslator newTranslator(Environment env) {
        JavaScriptTranslator translator = new JavaScriptTranslator(this.factory, this.context, this.source, env, false, this.moduleNode);
        translator.scriptOrModule = this.scriptOrModule;
        return translator;
    }
}

