/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.js.runtime.JSRuntime;

@ExportLibrary(value=InteropLibrary.class)
@CompilerDirectives.ValueType
public final class LargeInteger
extends Number
implements Comparable<LargeInteger>,
TruffleObject {
    final long value;
    private static final long serialVersionUID = 2017825230215806491L;

    private LargeInteger(long value) {
        this.value = value;
    }

    public static LargeInteger valueOf(int value) {
        return new LargeInteger(value);
    }

    public static LargeInteger valueOf(long value) {
        if (!JSRuntime.isSafeInteger(value)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("not in safe integer range");
        }
        return new LargeInteger(value);
    }

    public static LargeInteger parseUnsignedInt(String value) {
        return LargeInteger.valueOf(Integer.parseUnsignedInt(value));
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LargeInteger) {
            return this.value == ((LargeInteger)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public int compareTo(LargeInteger other) {
        return Long.compareUnsigned(this.value, other.value);
    }

    public boolean isNegative() {
        return this.value < 0L;
    }

    public LargeInteger incrementExact() {
        if (this.value == JSRuntime.MAX_SAFE_INTEGER_LONG) {
            throw new ArithmeticException();
        }
        return LargeInteger.valueOf(this.value + 1L);
    }

    public LargeInteger decrementExact() {
        if (this.value == JSRuntime.MIN_SAFE_INTEGER_LONG) {
            throw new ArithmeticException();
        }
        return LargeInteger.valueOf(this.value - 1L);
    }

    public LargeInteger addExact(LargeInteger other) {
        long result = this.value + other.value;
        if (result < JSRuntime.MIN_SAFE_INTEGER_LONG || result > JSRuntime.MAX_SAFE_INTEGER_LONG) {
            throw new ArithmeticException();
        }
        return LargeInteger.valueOf(result);
    }

    public static boolean isInstance(TruffleObject object) {
        return object instanceof LargeInteger;
    }

    @ExportMessage
    boolean isNumber() {
        return true;
    }

    @ExportMessage
    boolean fitsInLong() {
        return true;
    }

    @ExportMessage
    long asLong() {
        return this.longValue();
    }

    @ExportMessage
    boolean fitsInInt(@CachedLibrary(value="this.value") InteropLibrary numbers) {
        return numbers.fitsInInt((Object)this.value);
    }

    @ExportMessage
    int asInt(@CachedLibrary(value="this.value") InteropLibrary numbers) throws UnsupportedMessageException {
        return numbers.asInt((Object)this.value);
    }

    @ExportMessage
    boolean fitsInDouble(@CachedLibrary(value="this.value") InteropLibrary numbers) {
        return numbers.fitsInDouble((Object)this.value);
    }

    @ExportMessage
    double asDouble(@CachedLibrary(value="this.value") InteropLibrary numbers) throws UnsupportedMessageException {
        return numbers.asDouble((Object)this.value);
    }

    @ExportMessage
    boolean fitsInByte(@CachedLibrary(value="this.value") InteropLibrary numbers) {
        return numbers.fitsInByte((Object)this.value);
    }

    @ExportMessage
    byte asByte(@CachedLibrary(value="this.value") InteropLibrary numbers) throws UnsupportedMessageException {
        return numbers.asByte((Object)this.value);
    }

    @ExportMessage
    boolean fitsInShort(@CachedLibrary(value="this.value") InteropLibrary numbers) {
        return numbers.fitsInShort((Object)this.value);
    }

    @ExportMessage
    short asShort(@CachedLibrary(value="this.value") InteropLibrary numbers) throws UnsupportedMessageException {
        return numbers.asShort((Object)this.value);
    }

    @ExportMessage
    boolean fitsInFloat(@CachedLibrary(value="this.value") InteropLibrary numbers) {
        return numbers.fitsInFloat((Object)this.value);
    }

    @ExportMessage
    float asFloat(@CachedLibrary(value="this.value") InteropLibrary numbers) throws UnsupportedMessageException {
        return numbers.asFloat((Object)this.value);
    }
}

