/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;

public final class JSModuleRecord
extends ScriptOrModule {
    private final Object module;
    private final JSModuleLoader moduleLoader;
    private Status status;
    private Throwable evaluationError;
    private Object executionResult;
    private JSFunctionData functionData;
    private FrameDescriptor frameDescriptor;
    private DynamicObject namespace;
    private MaterializedFrame environment;
    private DynamicObject importMeta;
    private Runnable finishTranslation;
    private int dfsIndex;
    private int dfsAncestorIndex;

    public JSModuleRecord(Object module, JSContext context, JSModuleLoader moduleLoader, Source source, Runnable finishTranslation) {
        super(context, source);
        this.module = module;
        this.moduleLoader = moduleLoader;
        this.finishTranslation = finishTranslation;
        this.setUninstantiated();
    }

    public Object getModule() {
        return this.module;
    }

    public JSModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    public JSFunctionData getFunctionData() {
        assert (this.functionData != null);
        return this.functionData;
    }

    public void setFunctionData(JSFunctionData functionData) {
        assert (this.functionData == null);
        this.functionData = functionData;
    }

    public FrameDescriptor getFrameDescriptor() {
        assert (this.frameDescriptor != null);
        return this.frameDescriptor;
    }

    public void setFrameDescriptor(FrameDescriptor frameDescriptor) {
        assert (this.frameDescriptor == null);
        this.frameDescriptor = frameDescriptor;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isEvaluated() {
        return this.getStatus() == Status.Evaluated;
    }

    public Throwable getEvaluationError() {
        assert (this.isEvaluated());
        return this.evaluationError;
    }

    public void setEvaluationError(Throwable evaluationError) {
        assert (this.isEvaluated());
        this.evaluationError = evaluationError;
    }

    public DynamicObject getNamespace() {
        return this.namespace;
    }

    public void setNamespace(DynamicObject namespace) {
        assert (this.namespace == null);
        this.namespace = namespace;
    }

    public MaterializedFrame getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(MaterializedFrame environment) {
        assert (this.environment == null);
        assert (this.frameDescriptor == environment.getFrameDescriptor());
        this.environment = environment;
    }

    public void finishTranslation() {
        assert (this.getStatus() == Status.Instantiating);
        this.finishTranslation.run();
        this.finishTranslation = null;
    }

    public int getDFSIndex() {
        assert (this.dfsIndex >= 0);
        return this.dfsIndex;
    }

    public void setDFSIndex(int dfsIndex) {
        this.dfsIndex = dfsIndex;
    }

    public int getDFSAncestorIndex() {
        assert (this.dfsAncestorIndex >= 0);
        return this.dfsAncestorIndex;
    }

    public void setDFSAncestorIndex(int dfsAncestorIndex) {
        this.dfsAncestorIndex = dfsAncestorIndex;
    }

    public Object getExecutionResult() {
        return this.executionResult;
    }

    public void setExecutionResult(Object executionResult) {
        this.executionResult = executionResult;
    }

    public DynamicObject getImportMeta() {
        if (this.importMeta == null) {
            this.importMeta = this.createMetaObject();
        }
        return this.importMeta;
    }

    private DynamicObject createMetaObject() {
        DynamicObject metaObj = JSUserObject.createWithNullPrototype(this.context);
        if (this.context.hasImportMetaInitializerBeenSet()) {
            this.context.notifyImportMetaInitializer(metaObj, this);
        } else {
            this.initializeMetaObject(metaObj);
        }
        return metaObj;
    }

    @CompilerDirectives.TruffleBoundary
    private void initializeMetaObject(DynamicObject metaObj) {
        JSObject.set(metaObj, "url", (Object)this.getSource().getURI().toString());
    }

    public void setUninstantiated() {
        this.setStatus(Status.Uninstantiated);
        this.environment = null;
        this.dfsIndex = -1;
        this.dfsAncestorIndex = -1;
    }

    public static enum Status {
        Uninstantiated,
        Instantiating,
        Instantiated,
        Evaluating,
        Evaluated;

    }
}

