/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.List;
import org.netbeans.lib.profiler.heap.ArrayDump;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectArrayLazyList;
import org.netbeans.lib.profiler.heap.ObjectArrayValuesLazyList;

class ObjectArrayDump
extends ArrayDump
implements ObjectArrayInstance {
    ObjectArrayDump(ClassDump cls, long offset) {
        super(cls, offset);
    }

    @Override
    public long getSize() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return (long)(this.dumpClass.classDumpSegment.getMinimumInstanceSize() + HPROF_ARRAY_OVERHEAD) + (long)idSize * (long)this.getLength();
    }

    @Override
    public List getValues() {
        HprofByteBuffer dumpBuffer = this.dumpClass.getHprofBuffer();
        HprofHeap heap = this.dumpClass.getHprof();
        return new ObjectArrayLazyList(heap, dumpBuffer, this.getLength(), this.getOffset());
    }

    @Override
    public List getItems() {
        return new ObjectArrayValuesLazyList(this.dumpClass, this.getLength(), this.fileOffset);
    }

    long getOffset() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return this.fileOffset + 1L + (long)idSize + 4L + 4L + (long)idSize;
    }
}

