/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.bind.support.SimpleSessionStatus;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.SyncInvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.SessionAttributesHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;

class InitBinderBindingContext
extends BindingContext {
    private final List<SyncInvocableHandlerMethod> binderMethods;
    private final BindingContext binderMethodContext;
    private final SessionStatus sessionStatus = new SimpleSessionStatus();
    @Nullable
    private Runnable saveModelOperation;

    InitBinderBindingContext(@Nullable WebBindingInitializer initializer, List<SyncInvocableHandlerMethod> binderMethods) {
        super(initializer);
        this.binderMethods = binderMethods;
        this.binderMethodContext = new BindingContext(initializer);
    }

    public SessionStatus getSessionStatus() {
        return this.sessionStatus;
    }

    @Override
    protected WebExchangeDataBinder initDataBinder(WebExchangeDataBinder dataBinder, ServerWebExchange exchange) {
        this.binderMethods.stream().filter(binderMethod -> {
            InitBinder ann = (InitBinder)binderMethod.getMethodAnnotation(InitBinder.class);
            Assert.state((ann != null ? 1 : 0) != 0, (String)"No InitBinder annotation");
            Object[] names = ann.value();
            return ObjectUtils.isEmpty((Object[])names) || ObjectUtils.containsElement((Object[])names, (Object)dataBinder.getObjectName());
        }).forEach(method2 -> this.invokeBinderMethod(dataBinder, exchange, (SyncInvocableHandlerMethod)((Object)method2)));
        return dataBinder;
    }

    private void invokeBinderMethod(WebExchangeDataBinder dataBinder, ServerWebExchange exchange, SyncInvocableHandlerMethod binderMethod) {
        HandlerResult result = binderMethod.invokeForHandlerResult(exchange, this.binderMethodContext, dataBinder);
        if (result != null && result.getReturnValue() != null) {
            throw new IllegalStateException("@InitBinder methods must not return a value (should be void): " + (Object)((Object)binderMethod));
        }
        if (!this.binderMethodContext.getModel().asMap().isEmpty()) {
            throw new IllegalStateException("@InitBinder methods are not allowed to add model attributes: " + (Object)((Object)binderMethod));
        }
    }

    public void setSessionContext(SessionAttributesHandler attributesHandler, WebSession session) {
        this.saveModelOperation = () -> {
            if (this.getSessionStatus().isComplete()) {
                attributesHandler.cleanupAttributes(session);
            } else {
                attributesHandler.storeAttributes(session, this.getModel().asMap());
            }
        };
    }

    public void saveModel() {
        if (this.saveModelOperation != null) {
            this.saveModelOperation.run();
        }
    }
}

