/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import org.netbeans.modules.php.editor.parser.astnodes.Statement;

public abstract class BodyDeclaration
extends Statement {
    private int modifier;

    public BodyDeclaration(int start, int end, int modifier, boolean shouldComplete) {
        super(start, end);
        this.modifier = shouldComplete ? BodyDeclaration.completeModifier(modifier) : modifier;
    }

    public BodyDeclaration(int start, int end, int modifier) {
        this(start, end, modifier, false);
    }

    public String getModifierString() {
        return Modifier.toString(this.modifier);
    }

    public int getModifier() {
        return this.modifier;
    }

    private static int completeModifier(int mod) {
        if (!Modifier.isPrivate(mod) && !Modifier.isProtected(mod)) {
            mod |= 1;
        }
        return mod;
    }

    public static class Modifier {
        public static final int PUBLIC = 1;
        public static final int PRIVATE = 2;
        public static final int PROTECTED = 4;
        public static final int STATIC = 8;
        public static final int FINAL = 16;
        public static final int IMPLICIT_PUBLIC = 32;
        public static final int ABSTRACT = 1024;

        public static boolean isPublic(int mod) {
            return (mod & 1) != 0 || (mod & 0x20) != 0;
        }

        public static boolean isImplicitPublic(int mod) {
            return (mod & 0x20) != 0;
        }

        public static boolean isPrivate(int mod) {
            return (mod & 2) != 0;
        }

        public static boolean isProtected(int mod) {
            return (mod & 4) != 0;
        }

        public static boolean isStatic(int mod) {
            return (mod & 8) != 0;
        }

        public static boolean isFinal(int mod) {
            return (mod & 0x10) != 0;
        }

        public static boolean isAbstract(int mod) {
            return (mod & 0x400) != 0;
        }

        public static String toString(int mod) {
            int len;
            StringBuffer sb = new StringBuffer();
            if ((mod & 1) != 0 || (mod & 0x20) != 0) {
                sb.append("public ");
            }
            if ((mod & 4) != 0) {
                sb.append("protected ");
            }
            if ((mod & 2) != 0) {
                sb.append("private ");
            }
            if ((mod & 0x400) != 0) {
                sb.append("abstract ");
            }
            if ((mod & 8) != 0) {
                sb.append("static ");
            }
            if ((mod & 0x10) != 0) {
                sb.append("final ");
            }
            if ((len = sb.length()) > 0) {
                return sb.toString().substring(0, len - 1);
            }
            return "";
        }
    }
}

