/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nashorn.execution;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.modules.nashorn.execution.options.Settings;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;

public class JSExecutor {
    private static final String NASHORN_SHELL = "jdk.nashorn.tools.Shell";

    public static void run(JavaPlatform javaPlatform, FileObject js, boolean debug) throws IOException, UnsupportedOperationException {
        LifecycleManager.getDefault().saveAll();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("platform", javaPlatform);
        properties.put("classname", NASHORN_SHELL);
        properties.put("execute.classpath", JSExecutor.getClassPath(js));
        properties.put("work.dir", js.getParent());
        properties.put("application.args", JSExecutor.getApplicationArgs(js));
        if (debug) {
            JavaRunner.execute((String)"debug", properties);
        } else {
            JavaRunner.execute((String)"run", properties);
        }
    }

    private static ClassPath getClassPath(FileObject js) {
        ClassPath cp = ClassPath.getClassPath((FileObject)js, (String)"classpath/execute");
        if (cp == null) {
            cp = ClassPath.EMPTY;
        }
        return cp;
    }

    private static List<String> getApplicationArgs(FileObject js) {
        String options = Settings.getPreferences().get("nashornEngineOptions", null);
        String arguments = Settings.getPreferences().get("nashornScriptArguments", null);
        if (options == null && arguments == null) {
            return Collections.singletonList(js.getNameExt());
        }
        LinkedList<String> args = new LinkedList<String>();
        if (options != null && !(options = options.trim()).isEmpty()) {
            args.add(options);
        }
        args.add(js.getNameExt());
        if (arguments != null && !(arguments = arguments.trim()).isEmpty()) {
            args.add("--");
            args.add(arguments);
        }
        return args;
    }
}

