/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public final class DecimalValue
extends NumericValue {
    public static final int DIVIDE_PRECISION = 18;
    private static boolean stripTrailingZerosMethodUnavailable = false;
    private static Method stripTrailingZerosMethod = null;
    private static boolean canSetScaleNegative = true;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private BigDecimal value;
    public static final BigDecimal BIG_DECIMAL_ONE = BigDecimal.valueOf(1L);
    public static final BigInteger BIG_INTEGER_TEN = BigInteger.valueOf(10L);
    public static final BigDecimal BIG_DECIMAL_ONE_MILLION = BigDecimal.valueOf(1000000L);
    public static final DecimalValue ZERO = new DecimalValue(BigDecimal.valueOf(0L));
    public static final DecimalValue ONE = new DecimalValue(BigDecimal.valueOf(1L));
    private static final Pattern decimalPattern = Pattern.compile("(\\-|\\+)?((\\.[0-9]+)|([0-9]+(\\.[0-9]*)?))");

    public DecimalValue(BigDecimal value) {
        this.value = DecimalValue.stripTrailingZeros(value);
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public static ConversionResult makeDecimalValue(CharSequence in, boolean validate) {
        String trimmed = ((Object)Whitespace.trimWhitespace(in)).toString();
        try {
            if (validate && !decimalPattern.matcher(trimmed).matches()) {
                ValidationFailure err = new ValidationFailure("Cannot convert string " + Err.wrap(trimmed, 4) + " to xs:decimal");
                err.setErrorCode("FORG0001");
                return err;
            }
            BigDecimal val = new BigDecimal(trimmed);
            val = DecimalValue.stripTrailingZeros(val);
            return new DecimalValue(val);
        }
        catch (NumberFormatException err) {
            ValidationFailure e = new ValidationFailure("Cannot convert string " + Err.wrap(trimmed, 4) + " to xs:decimal");
            e.setErrorCode("FORG0001");
            return e;
        }
    }

    public static boolean castableAsDecimal(CharSequence in) {
        CharSequence trimmed = Whitespace.trimWhitespace(in);
        return decimalPattern.matcher(trimmed).matches();
    }

    public DecimalValue(double in) throws ValidationException {
        try {
            this.value = DecimalValue.stripTrailingZeros(new BigDecimal(in));
        }
        catch (NumberFormatException err) {
            ValidationException e = new ValidationException("Cannot convert double " + Err.wrap(in + "", 4) + " to decimal");
            e.setErrorCode("FOCA0002");
            throw e;
        }
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public DecimalValue(long in) {
        this.value = BigDecimal.valueOf(in);
        this.typeLabel = BuiltInAtomicType.DECIMAL;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        DecimalValue v = new DecimalValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.DECIMAL;
    }

    private static BigDecimal stripTrailingZeros(BigDecimal value) {
        if (stripTrailingZerosMethodUnavailable) {
            return DecimalValue.stripTrailingZerosFallback(value);
        }
        try {
            if (stripTrailingZerosMethod == null) {
                Class[] argTypes = new Class[]{};
                stripTrailingZerosMethod = BigDecimal.class.getMethod("stripTrailingZeros", argTypes);
            }
            Object result = stripTrailingZerosMethod.invoke((Object)value, EMPTY_OBJECT_ARRAY);
            return (BigDecimal)result;
        }
        catch (NoSuchMethodException e) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(value);
        }
        catch (IllegalAccessException e) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(value);
        }
        catch (InvocationTargetException e) {
            stripTrailingZerosMethodUnavailable = true;
            return DecimalValue.stripTrailingZerosFallback(value);
        }
    }

    private static BigDecimal stripTrailingZerosFallback(BigDecimal value) {
        int scale = value.scale();
        if (scale > 0) {
            BigInteger[] dr;
            BigInteger i = value.unscaledValue();
            while ((dr = i.divideAndRemainder(BIG_INTEGER_TEN))[1].equals(BigInteger.ZERO)) {
                i = dr[0];
                if (--scale != 0) continue;
                break;
            }
            if (scale != value.scale()) {
                value = new BigDecimal(i, scale);
            }
        }
        return value;
    }

    public BigDecimal getDecimalValue() {
        return this.value;
    }

    public int hashCode() {
        BigDecimal round = this.value.setScale(0, 1);
        long value = round.longValue();
        if (value > Integer.MIN_VALUE && value < Integer.MAX_VALUE) {
            return (int)value;
        }
        return new Double(this.getDoubleValue()).hashCode();
    }

    public boolean effectiveBooleanValue() {
        return this.value.signum() != 0;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getFingerprint()) {
            case 514: {
                return BooleanValue.get(this.value.signum() != 0);
            }
            case 515: 
            case 632: 
            case 635: {
                return this;
            }
            case 532: {
                return BigIntegerValue.makeIntegerValue(this.value.toBigInteger());
            }
            case 533: 
            case 534: 
            case 535: 
            case 536: 
            case 537: 
            case 538: 
            case 539: 
            case 540: 
            case 541: 
            case 542: 
            case 543: 
            case 544: {
                IntegerValue iv = BigIntegerValue.makeIntegerValue(this.value.toBigInteger());
                return iv.convertPrimitive(requiredType, validate, context);
            }
            case 517: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 516: {
                return new FloatValue(this.value.floatValue());
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert decimal to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public CharSequence getStringValueCS() {
        return DecimalValue.decimalToString(this.value, new FastStringBuffer(20));
    }

    public CharSequence getCanonicalLexicalRepresentation() {
        String s = this.getStringValue();
        if (s.indexOf(46) < 0) {
            s = s + ".0";
        }
        return s;
    }

    public String getStringValue() {
        return DecimalValue.decimalToString(this.value, new FastStringBuffer(20)).toString();
    }

    public static FastStringBuffer decimalToString(BigDecimal value, FastStringBuffer fsb) {
        int scale = value.scale();
        if (scale == 0) {
            fsb.append(value.toString());
            return fsb;
        }
        if (scale < 0) {
            String s = value.abs().unscaledValue().toString();
            if (s.equals("0")) {
                fsb.append('0');
                return fsb;
            }
            if (value.signum() < 0) {
                fsb.append('-');
            }
            fsb.append(s);
            for (int i = 0; i < -scale; ++i) {
                fsb.append('0');
            }
            return fsb;
        }
        String s = value.abs().unscaledValue().toString();
        if (s.equals("0")) {
            fsb.append('0');
            return fsb;
        }
        int len = s.length();
        if (value.signum() < 0) {
            fsb.append('-');
        }
        if (scale >= len) {
            fsb.append("0.");
            for (int i = len; i < scale; ++i) {
                fsb.append('0');
            }
            fsb.append(s);
        } else {
            fsb.append(s.substring(0, len - scale));
            fsb.append('.');
            fsb.append(s.substring(len - scale));
        }
        return fsb;
    }

    public NumericValue negate() {
        return new DecimalValue(this.value.negate());
    }

    public NumericValue floor() {
        return new DecimalValue(this.value.setScale(0, 3));
    }

    public NumericValue ceiling() {
        return new DecimalValue(this.value.setScale(0, 2));
    }

    public NumericValue round() {
        switch (this.value.signum()) {
            case -1: {
                return new DecimalValue(this.value.setScale(0, 5));
            }
            case 0: {
                return this;
            }
            case 1: {
                return new DecimalValue(this.value.setScale(0, 4));
            }
        }
        return this;
    }

    public NumericValue roundHalfToEven(int scale) {
        BigDecimal scaledValue;
        if (scale < 0 && !canSetScaleNegative) {
            try {
                AtomicValue val = this.convertPrimitive(BuiltInAtomicType.INTEGER, true, null).asAtomic();
                if (val instanceof Int64Value) {
                    return ((Int64Value)val).roundHalfToEven(scale);
                }
                return ((BigIntegerValue)val).roundHalfToEven(scale);
            }
            catch (XPathException err) {
                throw new IllegalArgumentException("internal error in integer-decimal conversion");
            }
        }
        try {
            scaledValue = this.value.setScale(scale, 6);
        }
        catch (ArithmeticException e) {
            if (scale < 0) {
                canSetScaleNegative = false;
                return this.roundHalfToEven(scale);
            }
            throw e;
        }
        return new DecimalValue(DecimalValue.stripTrailingZeros(scaledValue));
    }

    public double signum() {
        return this.value.signum();
    }

    public boolean isWholeNumber() {
        return this.value.scale() == 0 || this.value.compareTo(this.value.setScale(0, 1)) == 0;
    }

    public int compareTo(Object other) {
        if (NumericValue.isInteger((NumericValue)other)) {
            try {
                return this.compareTo(((NumericValue)other).convertPrimitive(BuiltInAtomicType.DECIMAL, true, null).asAtomic());
            }
            catch (XPathException err) {
                throw new AssertionError((Object)"Conversion of integer to decimal should never fail");
            }
        }
        if (other instanceof DecimalValue) {
            return this.value.compareTo(((DecimalValue)other).value);
        }
        if (other instanceof FloatValue) {
            try {
                return ((FloatValue)this.convertPrimitive(BuiltInAtomicType.FLOAT, true, null).asAtomic()).compareTo(other);
            }
            catch (XPathException err) {
                throw new AssertionError((Object)"Conversion of decimal to float should never fail");
            }
        }
        return super.compareTo(other);
    }

    public int compareTo(long other) {
        if (other == 0L) {
            return this.value.signum();
        }
        return this.value.compareTo(BigDecimal.valueOf(other));
    }

    public Comparable getSchemaComparable() {
        return new DecimalComparable(this);
    }

    protected static class DecimalComparable
    implements Comparable {
        protected DecimalValue value;

        public DecimalComparable(DecimalValue value) {
            this.value = value;
        }

        public BigDecimal asBigDecimal() {
            return this.value.getDecimalValue();
        }

        public int compareTo(Object o) {
            if (o instanceof DecimalComparable) {
                return this.asBigDecimal().compareTo(((DecimalComparable)o).asBigDecimal());
            }
            if (o instanceof Int64Value.Int64Comparable) {
                return this.asBigDecimal().compareTo(BigDecimal.valueOf(((Int64Value.Int64Comparable)o).asLong()));
            }
            if (o instanceof BigIntegerValue.BigIntegerComparable) {
                return this.value.compareTo(new BigDecimal(((BigIntegerValue.BigIntegerComparable)o).asBigInteger()));
            }
            return Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return this.compareTo(o) == 0;
        }

        public int hashCode() {
            if (this.value.isWholeNumber()) {
                try {
                    return this.value.convertPrimitive(BuiltInAtomicType.INTEGER, true, null).asAtomic().getSchemaComparable().hashCode();
                }
                catch (ValidationException e) {
                    return 12345678;
                }
            }
            return this.value.hashCode();
        }
    }
}

