/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.netbeans.modules.profiler.nbimpl.BuildEndListener;
import org.netbeans.modules.profiler.nbimpl.NetBeansProfiler;
import org.netbeans.modules.profiler.nbimpl.actions.ProfilerLauncher;

public final class NBProfileDirectTask
extends Task {
    private static final int INTERACTIVE_AUTO = 0;
    private static final int INTERACTIVE_YES = 1;
    private static final int INTERACTIVE_NO = 2;
    private static final String DEFAULT_AGENT_JVMARGS_PROPERTY = "profiler.info.jvmargs.agent";
    private static final String DEFAULT_JVM_PROPERTY = "profiler.info.jvm";
    private Path classpath = null;
    private Path rootsPath = null;
    private String jvmArgsPrefix = "";
    private String jvmArgsProperty = "profiler.info.jvmargs.agent";
    private String jvmProperty = "profiler.info.jvm";
    private String mainClass = null;
    private int interactive = 0;
    private AtomicBoolean connectionCancel = new AtomicBoolean();

    public void setInteractive(YesNoAuto arg) {
        String value = arg.getValue();
        if (value.equals("auto")) {
            this.interactive = 0;
        } else if (value.equals("yes") || value.equals("true")) {
            this.interactive = 1;
        } else if (value.equals("no") || value.equals("false")) {
            this.interactive = 2;
        }
    }

    public void setJvmArgsPrefix(String value) {
        this.jvmArgsPrefix = value;
    }

    public void setJvmArgsProperty(String value) {
        this.jvmArgsProperty = value;
    }

    public void setJvmProperty(String value) {
        this.jvmProperty = value;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void addClasspath(Path path) {
        if (this.classpath != null) {
            throw new BuildException("Only one classpath subelement is supported");
        }
        this.classpath = path;
    }

    public void addRootspath(Path path) {
        if (this.rootsPath != null) {
            throw new BuildException("Only one classpath subelement is supported");
        }
        this.rootsPath = path;
    }

    public void execute() throws BuildException {
        ProfilerLauncher.Session s = ProfilerLauncher.getLastSession();
        if (s != null && s.isConfigured()) {
            Map props = s.getProperties();
            if (props != null) {
                for (Map.Entry e : props.entrySet()) {
                    this.getProject().setProperty((String)e.getKey(), (String)e.getValue());
                }
                this.getProject().setProperty("profiler.jvmargs", "-J-Dprofiler.pre72=true");
                this.getProject().addBuildListener((BuildListener)new BuildEndListener(this.connectionCancel));
                if (!NetBeansProfiler.getDefaultNB().startEx(s.getProfilingSettings(), s.getSessionSettings(), this.connectionCancel)) {
                    throw new BuildException("User abort");
                }
            }
        } else {
            throw new BuildException("User abort");
        }
    }

    public static class YesNoAuto
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"yes", "true", "no", "false", "auto"};
        }
    }
}

