/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.utils;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.utils.Bundle;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.util.actions.SystemAction;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class LogUtils {
    private LogUtils() {
    }

    public static void logBranchUpdateReview(File repository, String branchName, String oldId, String newId, OutputLogger logger) {
        if (oldId != null && newId != null && !oldId.equals(newId)) {
            Object list2;
            Object list1;
            String line = Bundle.MSG_LogUtils_updateBranch_actions("{0}", "{1}");
            int historyPos = line.indexOf("{0}");
            int diffPos = line.indexOf("{1}");
            ArrayList<String> segments = new ArrayList<String>();
            if (historyPos < diffPos) {
                segments.add(line.substring(0, historyPos));
                segments.add(Bundle.MSG_LogUtils_updateBranch_actions_history());
                list1 = new ShowHistoryListener(repository, oldId, newId);
                segments.add(line.substring(historyPos + 3, diffPos));
                segments.add(Bundle.MSG_LogUtils_updateBranch_actions_diff());
                list2 = new DiffListener(repository, branchName, oldId, newId);
                segments.add(line.substring(diffPos + 3));
            } else {
                segments.add(line.substring(0, diffPos));
                segments.add(Bundle.MSG_LogUtils_updateBranch_actions_diff());
                list1 = new DiffListener(repository, branchName, oldId, newId);
                segments.add(line.substring(diffPos + 3, historyPos));
                segments.add(Bundle.MSG_LogUtils_updateBranch_actions_history());
                list2 = new ShowHistoryListener(repository, oldId, newId);
                segments.add(line.substring(historyPos + 3));
            }
            logger.output((String)segments.get(0), null);
            logger.output((String)segments.get(1), (OutputListener)list1);
            logger.output((String)segments.get(2), null);
            logger.output((String)segments.get(3), (OutputListener)list2);
            logger.output((String)segments.get(4), null);
        }
        logger.outputLine("");
    }

    private static class DiffListener
    implements OutputListener {
        private final File repository;
        private final String branchName;
        private final String from;
        private final String to;

        public DiffListener(File repository, String branchName, String from, String to) {
            this.repository = new File(repository.getAbsolutePath());
            this.branchName = branchName;
            this.from = from.length() > 7 ? from.substring(0, 7) : from;
            this.to = to.length() > 7 ? to.substring(0, 7) : to;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            ((DiffAction)SystemAction.get(DiffAction.class)).diff(GitUtils.getContextForFile(this.repository), new Revision(this.from, Bundle.MSG_LogUtils_updateBranch_actions_diff_previous(this.branchName, this.from)), new Revision(this.to, Bundle.MSG_LogUtils_updateBranch_actions_diff_previous(this.branchName, this.to)));
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }

    private static class ShowHistoryListener
    implements OutputListener {
        private final File repository;
        private final String from;
        private final String to;

        public ShowHistoryListener(File repository, String from, String to) {
            this.repository = new File(repository.getAbsolutePath());
            this.from = from.length() > 7 ? from.substring(0, 7) : from;
            this.to = to.length() > 7 ? to.substring(0, 7) : to;
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
            SearchHistoryAction.openSearch(this.repository, this.repository, this.repository.getName(), this.from, this.to);
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

