/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.modules.ide.ergonomics.fod.FindComponentModules;
import org.netbeans.modules.ide.ergonomics.fod.FoDLayersProvider;
import org.netbeans.modules.ide.ergonomics.fod.InstallOrActivateTask;
import org.netbeans.modules.ide.ergonomics.fod.ModulesActivator;
import org.netbeans.modules.ide.ergonomics.fod.ProgressMonitor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ModulesInstaller {
    private Collection<UpdateElement> modules4install;
    private RequestProcessor.Task installTask = null;
    private OperationContainer<InstallSupport> installContainer;
    private ProgressHandle downloadHandle;
    private ProgressHandle verifyHandle;
    private ProgressHandle installHandle;
    private final FindComponentModules finder;
    private final ProgressMonitor progressMonitor;

    public ModulesInstaller(Collection<UpdateElement> modules, FindComponentModules find) {
        this(modules, find, null);
    }

    public ModulesInstaller(Collection<UpdateElement> modules, FindComponentModules find, ProgressMonitor progressMonitor) {
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct InstallerMissingModules with null or empty Collection " + modules);
        }
        this.modules4install = modules;
        this.finder = find;
        this.progressMonitor = progressMonitor != null ? progressMonitor : ProgressMonitor.DEV_NULL_PROGRESS_MONITOR;
    }

    static boolean activateModules(boolean askForInstall, ProgressMonitor monitor, FeatureInfo info, Collection<UpdateElement> alreadyOffered, Set<FeatureInfo.ExtraModuleInfo> filter) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ!";
        Function<FindComponentModules, Collection> toInstall = state -> {
            LinkedHashSet<UpdateElement> tmp = new LinkedHashSet<UpdateElement>(state.getModulesForInstall());
            tmp.removeAll(alreadyOffered);
            return tmp;
        };
        Function<FindComponentModules, Collection> toEnable = state -> state.getModulesForEnable();
        FindComponentModules findModules = new FindComponentModules(info, filter, new FeatureInfo[0]);
        if (askForInstall && !toInstall.apply(findModules).isEmpty()) {
            OperationContainer op = OperationContainer.createForInstall();
            op.add(toInstall.apply(findModules));
            if (!PluginManager.openInstallWizard((OperationContainer)op)) {
                return false;
            }
            findModules = new FindComponentModules(info, filter, new FeatureInfo[0]);
            if (!toInstall.apply(findModules).isEmpty()) {
                return false;
            }
        }
        if (!toInstall.apply(findModules).isEmpty()) {
            ModulesInstaller installer = new ModulesInstaller(toInstall.apply(findModules), findModules, monitor);
            installer.getInstallTask().schedule(10);
            installer.getInstallTask().waitFinished();
            findModules = new FindComponentModules(info, filter, new FeatureInfo[0]);
            if (!findModules.getModulesForInstall().isEmpty()) {
                return false;
            }
        }
        if (!toEnable.apply(findModules).isEmpty()) {
            ModulesActivator enabler = new ModulesActivator(toEnable.apply(findModules), findModules, monitor);
            enabler.getEnableTask().schedule(100);
            enabler.getEnableTask().waitFinished();
        }
        FoDLayersProvider.getInstance().refreshForce();
        return true;
    }

    public void assignDownloadHandle(ProgressHandle handle) {
        this.downloadHandle = handle;
    }

    public void assignVerifyHandle(ProgressHandle handle) {
        this.verifyHandle = handle;
    }

    public void assignInstallHandle(ProgressHandle handle) {
        this.installHandle = handle;
    }

    public RequestProcessor.Task getInstallTask() {
        if (this.installTask == null) {
            this.installTask = this.createInstallTask();
        }
        return this.installTask;
    }

    private RequestProcessor.Task createInstallTask() {
        assert (this.installTask == null || this.installTask.isFinished()) : "The Install Task cannot be started nor scheduled.";
        this.installTask = FeatureManager.getInstance().create(new InstallOrActivateTask(this));
        return this.installTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void installMissingModules() {
        try {
            this.doInstallMissingModules();
        }
        catch (Exception x) {
            JButton tryAgain = new JButton();
            tryAgain.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RequestProcessor.Task task;
                    if (ModulesInstaller.this.installContainer != null) {
                        try {
                            ((InstallSupport)ModulesInstaller.this.installContainer.getSupport()).doCancel();
                        }
                        catch (Exception ex) {
                            Logger.getLogger(ModulesInstaller.class.getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                        }
                    }
                    if ((task = ModulesInstaller.this.getInstallTask()) != null) {
                        task.schedule(10);
                    }
                }
            });
            Logger.getLogger(ModulesInstaller.class.getName()).log(Level.INFO, x.getLocalizedMessage(), x);
            tryAgain.setEnabled(this.getInstallTask() != null);
            Mnemonics.setLocalizedText((AbstractButton)tryAgain, (String)ModulesInstaller.getBundle("InstallerMissingModules_TryAgainButton", new Object[0]));
            NotifyDescriptor nd = new NotifyDescriptor((Object)this.getErrorNotifyPanel(x), ModulesInstaller.getBundle("InstallerMissingModules_ErrorPanel_Title", new Object[0]), -1, 0, new Object[]{tryAgain, NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notifyLater(nd);
        }
        finally {
            FoDLayersProvider.getInstance().refreshForce();
        }
    }

    private JComponent getErrorNotifyPanel(Exception x) {
        JTextArea area = new JTextArea();
        area.setWrapStyleWord(true);
        area.setLineWrap(true);
        area.setEditable(false);
        area.setRows(15);
        area.setColumns(40);
        area.setOpaque(false);
        area.setText(ModulesInstaller.getBundle("InstallerMissingModules_ErrorPanel", x.getLocalizedMessage(), x));
        return area;
    }

    private void doInstallMissingModules() throws OperationException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot be called in EQ.";
        this.installContainer = null;
        for (UpdateElement module : this.modules4install) {
            if (this.installContainer == null) {
                boolean isNewOne = module.getUpdateUnit().getInstalled() == null;
                this.installContainer = isNewOne ? OperationContainer.createForInstall() : OperationContainer.createForUpdate();
            }
            if (!this.installContainer.canBeAdded(module.getUpdateUnit(), module)) continue;
            this.installContainer.add(module);
        }
        if (this.installContainer.listAll().isEmpty()) {
            return;
        }
        assert (this.installContainer.listInvalid().isEmpty()) : "No invalid Update Elements " + this.installContainer.listInvalid();
        if (!this.installContainer.listInvalid().isEmpty()) {
            throw new IllegalArgumentException("Some are invalid for install: " + this.installContainer.listInvalid());
        }
        boolean ok = PluginManager.openInstallWizard(this.installContainer);
        if (!ok) {
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (UpdateElement el : this.modules4install) {
                sb.append(sep);
                sb.append(el.getDisplayName());
                sep = ", ";
            }
            this.progressMonitor.onError(ModulesInstaller.getBundle("InstallerMissingModules_Cancelled", sb));
        }
    }

    public static String presentUpdateElements(Collection<UpdateElement> elems) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        HashSet<String> used = new HashSet<String>();
        for (UpdateElement el : elems) {
            if (!used.add(el.getCategory())) continue;
            sb.append(sep);
            sb.append(el.getCategory());
            if (sb.length() > 30) {
                sb.append("...");
                break;
            }
            sep = ", ";
        }
        return sb.toString();
    }

    private void waitToModuleLoaded() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot be called in EQ.";
        for (UpdateElement m : this.modules4install) {
            while (!m.isEnabled()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private static String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(ModulesInstaller.class, (String)key, (Object[])params);
    }
}

