/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.util.Arrays;
import java.util.Collection;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.web.common.ui.refactoring.RenameRefactoringUI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;

public class HtmlActionsImplementationProvider
extends ActionsImplementationProvider {
    public static Collection<String> REFACTORABLE_TYPES = Arrays.asList("text/html", "text/xhtml", "text/css", "text/javascript", "text/x-json", "image/gif", "image/jpeg", "image/png", "image/bmp");

    public boolean canRename(Lookup lookup) {
        Collection nodes = lookup.lookupAll(Node.class);
        if (nodes.size() != 1) {
            return false;
        }
        Node node = (Node)nodes.iterator().next();
        EditorCookie ec = HtmlActionsImplementationProvider.getEditorCookie(node);
        if (ec == null || !HtmlActionsImplementationProvider.isFromEditor(ec)) {
            FileObject fo = HtmlActionsImplementationProvider.getFileObjectFromNode(node);
            return fo != null && REFACTORABLE_TYPES.contains(fo.getMIMEType());
        }
        return false;
    }

    public void doRename(Lookup selectedNodes) {
        Collection nodes = selectedNodes.lookupAll(Node.class);
        assert (nodes.size() == 1);
        Node node = (Node)nodes.iterator().next();
        FileObject file = HtmlActionsImplementationProvider.getFileObjectFromNode(node);
        UI.openRefactoringUI((RefactoringUI)new RenameRefactoringUI(file));
    }

    private static FileObject getFileObjectFromNode(Node node) {
        DataObject dobj = (DataObject)node.getLookup().lookup(DataObject.class);
        return dobj != null ? dobj.getPrimaryFile() : null;
    }

    private static boolean isFromEditor(final EditorCookie ec) {
        return (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                TopComponent activetc;
                if (ec != null && ec.getOpenedPanes() != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane) {
                    return true;
                }
                return false;
            }
        });
    }

    private static EditorCookie getEditorCookie(Node node) {
        return (EditorCookie)node.getLookup().lookup(EditorCookie.class);
    }
}

