/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.extbrowser.plugins.ExtensionManagerAccessor;
import org.netbeans.modules.extbrowser.plugins.chrome.ChromeManagerAccessor;
import org.netbeans.modules.extbrowser.plugins.chrome.ChromiumManagerAccessor;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;

public final class ExtensionManager {
    private static Map<BrowserFamilyId, ExtensionManagerAccessor> ACCESSORS = new HashMap<BrowserFamilyId, ExtensionManagerAccessor>();

    private ExtensionManager() {
    }

    public static ExtensitionStatus isInstalled(BrowserFamilyId id) {
        if (id != null) {
            ExtensionManagerAccessor accessor = ACCESSORS.get(id);
            if (accessor == null) {
                return ExtensitionStatus.UNKNOWN;
            }
            ExtensionManagerAccessor.BrowserExtensionManager manager = accessor.getManager();
            return manager.isInstalled();
        }
        return ExtensitionStatus.UNKNOWN;
    }

    public static boolean installExtension(BrowserFamilyId id, ExtensitionStatus currentStatus) {
        if (id != null) {
            ExtensionManagerAccessor accessor = ACCESSORS.get(id);
            if (accessor == null) {
                return false;
            }
            ExtensionManagerAccessor.BrowserExtensionManager manager = accessor.getManager();
            return manager.install(currentStatus);
        }
        return false;
    }

    static {
        ACCESSORS.put(BrowserFamilyId.CHROME, new ChromeManagerAccessor());
        ACCESSORS.put(BrowserFamilyId.CHROMIUM, new ChromiumManagerAccessor());
    }

    public static enum ExtensitionStatus {
        INSTALLED,
        MISSING,
        NEEDS_UPGRADE,
        DISABLED,
        UNKNOWN;

    }
}

