/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.web;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.projectimport.eclipse.web.ServerSelectionWizardPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ServerSelection
extends JPanel {
    private final DefaultComboBoxModel serversModel = new DefaultComboBoxModel();
    private ServerSelectionWizardPanel wp;
    private JButton addServerButton;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public ServerSelection(ServerSelectionWizardPanel wp) {
        this.wp = wp;
        this.initServers(null);
        this.initComponents();
        this.setName(NbBundle.getMessage(ServerSelection.class, (String)"TITLE_Server"));
        wp.setValid(this.getSelectedServer() != null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.addServerButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel1.setLabelFor(this.jComboBox1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ServerSelection.class, (String)"ServerSelection.jLabel1.text"));
        this.jComboBox1.setModel(this.serversModel);
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerSelection.this.jComboBox1ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addServerButton, (String)NbBundle.getMessage(ServerSelection.class, (String)"ServerSelection.addServerButton.text"));
        this.addServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerSelection.this.addServerButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServerSelection.class, (String)"ServerSelection.jLabel2.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox1, 0, 281, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addServerButton)).addComponent(this.jLabel2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.addServerButton).addComponent(this.jComboBox1, -2, -1, -2)).addContainerGap(236, Short.MAX_VALUE)));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerSelection.class, (String)"ACSD_ServerSelection_NA"));
        this.jComboBox1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerSelection.class, (String)"ACSD_ServerSelection_NA"));
        this.addServerButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerSelection.class, (String)"ACSD_ServerSelection_NA"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerSelection.class, (String)"ACSD_ServerSelection_NA"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServerSelection.class, (String)"ACSD_ServerSelection_NA"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerSelection.class, (String)"ACSD_ServerSelection_NA"));
    }

    private void addServerButtonActionPerformed(ActionEvent evt) {
        String newServerInstanceID = ServerManager.showAddServerInstanceWizard();
        this.initServers(newServerInstanceID);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.wp.setValid(this.getSelectedServer() != null);
    }

    public String getSelectedServer() {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper == null) {
            return null;
        }
        return serverInstanceWrapper.getServerInstanceID();
    }

    private void initServers(String selectedServerInstanceID) {
        this.serversModel.removeAllElements();
        TreeSet<ServerInstanceWrapper> servers = new TreeSet<ServerInstanceWrapper>();
        ServerInstanceWrapper selectedItem = null;
        boolean sjasFound = false;
        for (String serverInstanceID : Deployment.getDefault().getServerInstanceIDs()) {
            String displayName = null;
            J2eePlatform j2eePlatform = null;
            try {
                displayName = Deployment.getDefault().getServerInstance(serverInstanceID).getDisplayName();
                j2eePlatform = Deployment.getDefault().getServerInstance(serverInstanceID).getJ2eePlatform();
            }
            catch (InstanceRemovedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (displayName == null || j2eePlatform == null) continue;
            ServerInstanceWrapper serverWrapper = new ServerInstanceWrapper(serverInstanceID, displayName);
            if (selectedItem == null || !sjasFound) {
                if (selectedServerInstanceID != null) {
                    if (selectedServerInstanceID.equals(serverInstanceID)) {
                        selectedItem = serverWrapper;
                    }
                } else {
                    String shortName = null;
                    try {
                        shortName = Deployment.getDefault().getServerInstance(serverInstanceID).getServerID();
                    }
                    catch (InstanceRemovedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    if ("J2EE".equals(shortName)) {
                        selectedItem = serverWrapper;
                        sjasFound = true;
                    } else if ("JBoss4".equals(shortName)) {
                        selectedItem = serverWrapper;
                    }
                }
            }
            servers.add(serverWrapper);
        }
        for (ServerInstanceWrapper item : servers) {
            this.serversModel.addElement(item);
        }
        if (selectedItem != null) {
            this.serversModel.setSelectedItem(selectedItem);
        } else if (this.serversModel.getSize() > 0) {
            this.serversModel.setSelectedItem(this.serversModel.getElementAt(0));
        }
    }

    private static class ServerInstanceWrapper
    implements Comparable {
        private final String serverInstanceID;
        private final String displayName;

        ServerInstanceWrapper(String serverInstanceID, String displayName) {
            this.serverInstanceID = serverInstanceID;
            this.displayName = displayName;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

