/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.AtomicsBuiltins;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToIndexNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.LargeInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.function.BinaryOperator;
import java.util.function.IntBinaryOperator;

@GeneratedBy(value=AtomicsBuiltins.class)
public final class AtomicsBuiltinsFactory {

    @GeneratedBy(value=AtomicsBuiltins.AtomicsIsLockFreeNode.class)
    public static final class AtomicsIsLockFreeNodeGen
    extends AtomicsBuiltins.AtomicsIsLockFreeNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToInt32Node toInt32Node_;

        private AtomicsIsLockFreeNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state != 0) {
                return this.doGeneric(arguments0Value_, this.toInt32Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toInt32Node_ = (JSToInt32Node)super.insert((Node)JSToInt32Node.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doGeneric(arguments0Value, this.toInt32Node_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doGeneric";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JSToInt32Node>> cached = new ArrayList<List<JSToInt32Node>>();
                cached.add(Arrays.asList(this.toInt32Node_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static AtomicsBuiltins.AtomicsIsLockFreeNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new AtomicsIsLockFreeNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=AtomicsBuiltins.AtomicsWaitNode.class)
    public static final class AtomicsWaitNodeGen
    extends AtomicsBuiltins.AtomicsWaitNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @Node.Child
        private JavaScriptNode arguments3_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private GenericData generic_cache;

        private AtomicsWaitNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            GenericData s1_;
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            if (state != 0 && (s1_ = this.generic_cache) != null) {
                return this.doGeneric(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, s1_.toIndexNode_, s1_.timeToInt32Node_, s1_.loadNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                GenericData s1_ = (GenericData)super.insert((Node)new GenericData());
                s1_.toIndexNode_ = s1_.insertAccessor(JSToIndexNode.create());
                s1_.timeToInt32Node_ = s1_.insertAccessor(JSToNumberNode.create());
                s1_.loadNode_ = s1_.insertAccessor(this.createHelperNode());
                this.generic_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doGeneric(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, s1_.toIndexNode_, s1_.timeToInt32Node_, s1_.loadNode_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doGeneric";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                GenericData s1_ = this.generic_cache;
                if (s1_ != null) {
                    cached.add(Arrays.asList(new JavaScriptBaseNode[]{s1_.toIndexNode_, s1_.timeToInt32Node_, s1_.loadNode_}));
                }
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static AtomicsBuiltins.AtomicsWaitNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new AtomicsWaitNodeGen(context, builtin, arguments);
        }

        @GeneratedBy(value=AtomicsBuiltins.AtomicsWaitNode.class)
        private static final class GenericData
        extends Node {
            @Node.Child
            JSToIndexNode toIndexNode_;
            @Node.Child
            JSToNumberNode timeToInt32Node_;
            @Node.Child
            AtomicsBuiltins.AtomicsLoadNode loadNode_;

            GenericData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            <T extends Node> T insertAccessor(T node) {
                return (T)super.insert(node);
            }
        }
    }

    @GeneratedBy(value=AtomicsBuiltins.AtomicsWakeNode.class)
    public static final class AtomicsWakeNodeGen
    extends AtomicsBuiltins.AtomicsWakeNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToIndexNode toIndexNode_;
        @Node.Child
        private JSToInt32Node toInt32Node_;

        private AtomicsWakeNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if (state != 0) {
                return this.doGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.toIndexNode_, this.toInt32Node_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                this.toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                this.toInt32Node_ = (JSToInt32Node)super.insert((Node)JSToInt32Node.create());
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doGeneric(arguments0Value, arguments1Value, arguments2Value, this.toIndexNode_, this.toInt32Node_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doGeneric";
            if (state != 0) {
                s[1] = (byte)1;
                ArrayList<List<JavaScriptBaseNode>> cached = new ArrayList<List<JavaScriptBaseNode>>();
                cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.toIndexNode_, this.toInt32Node_}));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static AtomicsBuiltins.AtomicsWakeNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new AtomicsWakeNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=AtomicsBuiltins.AtomicsComputeNode.class)
    public static final class AtomicsComputeNodeGen
    extends AtomicsBuiltins.AtomicsComputeNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToIndexNode int32ArrayObjObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode bigInt64ArrayObjObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode generic_toIndexNode_;

        private AtomicsComputeNodeGen(JSContext context, JSBuiltin builtin, IntBinaryOperator intOperator, BinaryOperator<BigInt> bigIntOperator, JavaScriptNode[] arguments) {
            super(context, builtin, intOperator, bigIntOperator);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1C0) == 0 && state != 0) {
                return this.execute_int_int0(frameValue, state);
            }
            if ((state & 0x1BF) == 0 && state != 0) {
                return this.execute_int1(frameValue, state);
            }
            return this.execute_generic2(frameValue, state);
        }

        private Object execute_int_int0(VirtualFrame frameValue, int state) {
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            if ((state & 0x3F) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt8ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint8ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt16ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint16ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt32ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 0x20) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint32ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_int1(VirtualFrame frameValue, int state) {
            DynamicObject arguments0Value__;
            int arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state & 0x40) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, this.int32ArrayObjObjIdx_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic2(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 0xFF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 0x7F) != 0 && arguments2Value_ instanceof Integer) {
                    int arguments2Value__ = (Integer)arguments2Value_;
                    if ((state & 0x3F) != 0 && arguments1Value_ instanceof Integer) {
                        int arguments1Value__ = (Integer)arguments1Value_;
                        if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doInt8ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                        if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doUint8ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                        if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doInt16ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                        if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doUint16ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                        if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doInt32ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                        if ((state & 0x20) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doUint32ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                    }
                    if ((state & 0x40) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                        return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value__, this.int32ArrayObjObjIdx_toIndexNode_);
                    }
                }
                if ((state & 0x80) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value__))) {
                    return this.doBigInt64ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, this.bigInt64ArrayObjObjIdx_toIndexNode_);
                }
            }
            if ((state & 0x100) != 0) {
                return this.doGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.generic_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 0x100) != 0) {
                return JSTypesGen.expectInteger(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0x40) == 0 && (state & 0x5F) != 0) {
                return this.executeInt_int_int3(frameValue, state, arguments0Value_);
            }
            if ((state & 0x1F) == 0 && (state & 0x5F) != 0) {
                return this.executeInt_int4(frameValue, state, arguments0Value_);
            }
            return this.executeInt_generic5(frameValue, state, arguments0Value_);
        }

        private int executeInt_int_int3(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            int arguments2Value_;
            int arguments1Value_;
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value));
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult()));
            }
            if ((state & 0x1F) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt8ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint8ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt16ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint16ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt32ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_));
        }

        private int executeInt_int4(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            DynamicObject arguments0Value__;
            int arguments2Value_;
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult()));
            }
            assert ((state & 0x40) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, this.int32ArrayObjObjIdx_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_));
        }

        private int executeInt_generic5(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            int arguments2Value_;
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult()));
            }
            if ((state & 0x5F) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 0x1F) != 0 && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doInt8ArrayObj(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                    if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doUint8ArrayObj(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                    if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doInt16ArrayObj(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                    if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doUint16ArrayObj(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                    if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doInt32ArrayObj(arguments0Value__, arguments1Value__, arguments2Value_);
                    }
                }
                if ((state & 0x40) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                    return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, this.int32ArrayObjObjIdx_toIndexNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 0x1A0) == 0 && state != 0) {
                    this.executeInt(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments2Value instanceof Integer) {
                        int arguments2Value_ = (Integer)arguments2Value;
                        if (arguments1Value instanceof Integer) {
                            int arguments1Value_ = (Integer)arguments1Value;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                this.state_ = state |= 1;
                                lock.unlock();
                                hasLock = false;
                                Integer n = this.doInt8ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_);
                                return n;
                            }
                            if (AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                this.state_ = state |= 2;
                                lock.unlock();
                                hasLock = false;
                                Integer n = this.doUint8ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_);
                                return n;
                            }
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                this.state_ = state |= 4;
                                lock.unlock();
                                hasLock = false;
                                Integer n = this.doInt16ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_);
                                return n;
                            }
                            if (AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                this.state_ = state |= 8;
                                lock.unlock();
                                hasLock = false;
                                Integer n = this.doUint16ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_);
                                return n;
                            }
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                this.state_ = state |= 0x10;
                                lock.unlock();
                                hasLock = false;
                                Integer n = this.doInt32ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_);
                                return n;
                            }
                            if (AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                this.state_ = state |= 0x20;
                                lock.unlock();
                                hasLock = false;
                                LargeInteger largeInteger = this.doUint32ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_);
                                return largeInteger;
                            }
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_)) {
                            this.int32ArrayObjObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                            this.state_ = state |= 0x40;
                            lock.unlock();
                            hasLock = false;
                            Integer n = this.doInt32ArrayObjObjIdx(arguments0Value_, arguments1Value, arguments2Value_, this.int32ArrayObjObjIdx_toIndexNode_);
                            return n;
                        }
                    }
                    if (AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value_) || AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value_)) {
                        this.bigInt64ArrayObjObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                        this.state_ = state |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        BigInt bigInt = this.doBigInt64ArrayObjObjIdx(arguments0Value_, arguments1Value, arguments2Value, this.bigInt64ArrayObjObjIdx_toIndexNode_);
                        return bigInt;
                    }
                }
                this.generic_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Object object = this.doGeneric(arguments0Value, arguments1Value, arguments2Value, this.generic_toIndexNode_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<JSToIndexNode>> cached;
            Object[] data = new Object[10];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doInt8ArrayObj";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doUint8ArrayObj";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "doInt16ArrayObj";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "doUint16ArrayObj";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayObj";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "doUint32ArrayObj";
            s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayObjObjIdx";
            if ((state & 0x40) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<JSToIndexNode>>();
                cached.add(Arrays.asList(this.int32ArrayObjObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[7] = s;
            s = new Object[3];
            s[0] = "doBigInt64ArrayObjObjIdx";
            if ((state & 0x80) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.bigInt64ArrayObjObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[8] = s;
            s = new Object[3];
            s[0] = "doGeneric";
            if ((state & 0x100) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.generic_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[9] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static AtomicsBuiltins.AtomicsComputeNode create(JSContext context, JSBuiltin builtin, IntBinaryOperator intOperator, BinaryOperator<BigInt> bigIntOperator, JavaScriptNode[] arguments) {
            return new AtomicsComputeNodeGen(context, builtin, intOperator, bigIntOperator, arguments);
        }
    }

    @GeneratedBy(value=AtomicsBuiltins.AtomicsStoreNode.class)
    public static final class AtomicsStoreNodeGen
    extends AtomicsBuiltins.AtomicsStoreNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToIndexNode int32ArrayObjObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode bigInt64ArrayObjObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode generic_toIndexNode_;

        private AtomicsStoreNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x1EA) == 0 && (state & 0x1FF) != 0) {
                return this.execute_int_int0(frameValue, state);
            }
            if ((state & 0x1D5) == 0 && (state & 0x1FF) != 0) {
                return this.execute_int_double1(frameValue, state);
            }
            if ((state & 0x1BF) == 0 && (state & 0x1FF) != 0) {
                return this.execute_int2(frameValue, state);
            }
            return this.execute_generic3(frameValue, state);
        }

        private Object execute_int_int0(VirtualFrame frameValue, int state) {
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            if ((state & 0x15) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doIntArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 4) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt16ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 0x10) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt32ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_int_double1(VirtualFrame frameValue, int state) {
            double arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value);
            }
            int arguments2Value_int = 0;
            long arguments2Value_long = 0L;
            try {
                if ((state & 0x1C00) == 0 && (state & 0x1FF) != 0) {
                    arguments2Value_long = this.arguments2_.executeLong(frameValue);
                    arguments2Value_ = JSTypes.longToDouble(arguments2Value_long);
                } else if ((state & 0x1A00) == 0 && (state & 0x1FF) != 0) {
                    arguments2Value_int = this.arguments2_.executeInt(frameValue);
                    arguments2Value_ = JSTypes.intToDouble(arguments2Value_int);
                } else if ((state & 0x1600) == 0 && (state & 0x1FF) != 0) {
                    arguments2Value_ = this.arguments2_.executeDouble(frameValue);
                } else {
                    Object arguments2Value__ = this.arguments2_.execute(frameValue);
                    arguments2Value_ = JSTypesGen.expectImplicitDouble((state & 0x1E00) >>> 9, arguments2Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            if ((state & 0x2A) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 2) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doIntArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 8) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt16ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 0x20) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt32ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, (state & 0x1C00) == 0 && (state & 0x1FF) != 0 ? (Number)arguments2Value_long : (Number)((state & 0x1A00) == 0 && (state & 0x1FF) != 0 ? (Number)arguments2Value_int : (Number)arguments2Value_));
        }

        private Object execute_int2(VirtualFrame frameValue, int state) {
            DynamicObject arguments0Value__;
            int arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult());
            }
            assert ((state & 0x40) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, this.int32ArrayObjObjIdx_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        private Object execute_generic3(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 0xFF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 0x3F) != 0 && arguments1Value_ instanceof Integer) {
                    int arguments2Value__;
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state & 1) != 0 && arguments2Value_ instanceof Integer) {
                        arguments2Value__ = (Integer)arguments2Value_;
                        if ((AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doIntArrayObj(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                    }
                    if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, arguments2Value_)) {
                        double arguments2Value__2 = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, arguments2Value_);
                        if ((AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doIntArrayObj(arguments0Value__, arguments1Value__, arguments2Value__2);
                        }
                    }
                    if ((state & 4) != 0 && arguments2Value_ instanceof Integer) {
                        arguments2Value__ = (Integer)arguments2Value_;
                        if ((AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doInt16ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__);
                        }
                    }
                    if ((state & 8) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, arguments2Value_)) {
                        double arguments2Value__3 = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, arguments2Value_);
                        if ((AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doInt16ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__3);
                        }
                    }
                    if ((state & 0x10) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__4 = (Integer)arguments2Value_;
                        if ((AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doInt32ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__4);
                        }
                    }
                    if ((state & 0x20) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, arguments2Value_)) {
                        double arguments2Value__5 = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, arguments2Value_);
                        if ((AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                            return this.doInt32ArrayObj(arguments0Value__, arguments1Value__, arguments2Value__5);
                        }
                    }
                }
                if ((state & 0xC0) != 0) {
                    if ((state & 0x40) != 0 && arguments2Value_ instanceof Integer) {
                        int arguments2Value__ = (Integer)arguments2Value_;
                        if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                            return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value__, this.int32ArrayObjObjIdx_toIndexNode_);
                        }
                    }
                    if ((state & 0x80) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value__))) {
                        return this.doBigInt64ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, this.bigInt64ArrayObjObjIdx_toIndexNode_);
                    }
                }
            }
            if ((state & 0x100) != 0) {
                return this.doGeneric(arguments0Value_, arguments1Value_, arguments2Value_, this.generic_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int arguments1Value_;
            int state = this.state_;
            if ((state & 0x1E5) != 0) {
                return JSTypesGen.expectInteger(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value));
            }
            if ((state & 0x10) == 0 && (state & 0x1A) != 0) {
                return this.executeInt_double4(frameValue, state, arguments0Value_, arguments1Value_);
            }
            if ((state & 0xA) == 0 && (state & 0x1A) != 0) {
                return this.executeInt_int5(frameValue, state, arguments0Value_, arguments1Value_);
            }
            return this.executeInt_generic6(frameValue, state, arguments0Value_, arguments1Value_);
        }

        private int executeInt_double4(VirtualFrame frameValue, int state, Object arguments0Value_, int arguments1Value_) throws UnexpectedResultException {
            double arguments2Value_;
            int arguments2Value_int = 0;
            long arguments2Value_long = 0L;
            try {
                if ((state & 0x1C00) == 0 && (state & 0x1FF) != 0) {
                    arguments2Value_long = this.arguments2_.executeLong(frameValue);
                    arguments2Value_ = JSTypes.longToDouble(arguments2Value_long);
                } else if ((state & 0x1A00) == 0 && (state & 0x1FF) != 0) {
                    arguments2Value_int = this.arguments2_.executeInt(frameValue);
                    arguments2Value_ = JSTypes.intToDouble(arguments2Value_int);
                } else if ((state & 0x1600) == 0 && (state & 0x1FF) != 0) {
                    arguments2Value_ = this.arguments2_.executeDouble(frameValue);
                } else {
                    Object arguments2Value__ = this.arguments2_.execute(frameValue);
                    arguments2Value_ = JSTypesGen.expectImplicitDouble((state & 0x1E00) >>> 9, arguments2Value__);
                }
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult()));
            }
            if ((state & 0xA) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 2) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doIntArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
                if ((state & 8) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt16ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, (state & 0x1C00) == 0 && (state & 0x1FF) != 0 ? (Number)arguments2Value_long : (Number)((state & 0x1A00) == 0 && (state & 0x1FF) != 0 ? (Number)arguments2Value_int : (Number)arguments2Value_)));
        }

        private int executeInt_int5(VirtualFrame frameValue, int state, Object arguments0Value_, int arguments1Value_) throws UnexpectedResultException {
            DynamicObject arguments0Value__;
            int arguments2Value_;
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult()));
            }
            assert ((state & 0x10) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_) || AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                return this.doInt32ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_));
        }

        private int executeInt_generic6(VirtualFrame frameValue, int state, Object arguments0Value_, int arguments1Value_) throws UnexpectedResultException {
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            if ((state & 0x1A) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 0xA) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E00) >>> 9, arguments2Value_)) {
                    double arguments2Value__ = JSTypesGen.asImplicitDouble((state & 0x1E00) >>> 9, arguments2Value_);
                    if ((state & 2) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                        return this.doIntArrayObj(arguments0Value__, arguments1Value_, arguments2Value__);
                    }
                    if ((state & 8) != 0 && (AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                        return this.doInt16ArrayObj(arguments0Value__, arguments1Value_, arguments2Value__);
                    }
                }
                if ((state & 0x10) != 0 && arguments2Value_ instanceof Integer) {
                    int arguments2Value__ = (Integer)arguments2Value_;
                    if ((AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) || AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                        return this.doInt32ArrayObj(arguments0Value__, arguments1Value_, arguments2Value__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 0x1E5) == 0 && (state & 0x1FF) != 0) {
                    this.executeInt(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments1Value instanceof Integer) {
                        double arguments2Value_3;
                        int doubleCast2;
                        int arguments2Value_2;
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (arguments2Value instanceof Integer) {
                            arguments2Value_2 = (Integer)arguments2Value;
                            if ((AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value_) || AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value_)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                this.state_ = state |= 1;
                                lock.unlock();
                                hasLock = false;
                                Object object = this.doIntArrayObj(arguments0Value_, arguments1Value_, arguments2Value_2);
                                return object;
                            }
                        }
                        if ((doubleCast2 = JSTypesGen.specializeImplicitDouble(arguments2Value)) != 0) {
                            arguments2Value_3 = JSTypesGen.asImplicitDouble(doubleCast2, arguments2Value);
                            if ((AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value_) || AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value_)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                state |= doubleCast2 << 9;
                                this.state_ = state |= 2;
                                lock.unlock();
                                hasLock = false;
                                Integer n = this.doIntArrayObj(arguments0Value_, arguments1Value_, arguments2Value_3);
                                return n;
                            }
                        }
                        if (arguments2Value instanceof Integer) {
                            arguments2Value_2 = (Integer)arguments2Value;
                            if ((AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value_) || AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value_)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                this.state_ = state |= 4;
                                lock.unlock();
                                hasLock = false;
                                Object arguments2Value_3 = this.doInt16ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_2);
                                return arguments2Value_3;
                            }
                        }
                        if ((doubleCast2 = JSTypesGen.specializeImplicitDouble(arguments2Value)) != 0) {
                            arguments2Value_3 = JSTypesGen.asImplicitDouble(doubleCast2, arguments2Value);
                            if ((AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value_) || AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value_)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                state |= doubleCast2 << 9;
                                this.state_ = state |= 8;
                                lock.unlock();
                                hasLock = false;
                                Integer n = this.doInt16ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_3);
                                return n;
                            }
                        }
                        if (arguments2Value instanceof Integer) {
                            arguments2Value_2 = (Integer)arguments2Value;
                            if ((AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_) || AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value_)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                this.state_ = state |= 0x10;
                                lock.unlock();
                                hasLock = false;
                                Integer arguments2Value_4 = this.doInt32ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_2);
                                return arguments2Value_4;
                            }
                        }
                        if ((doubleCast2 = JSTypesGen.specializeImplicitDouble(arguments2Value)) != 0) {
                            arguments2Value_3 = JSTypesGen.asImplicitDouble(doubleCast2, arguments2Value);
                            if ((AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_) || AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value_)) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                                state |= doubleCast2 << 9;
                                this.state_ = state |= 0x20;
                                lock.unlock();
                                hasLock = false;
                                Object object = this.doInt32ArrayObj(arguments0Value_, arguments1Value_, arguments2Value_3);
                                return object;
                            }
                        }
                    }
                    if (arguments2Value instanceof Integer) {
                        int arguments2Value_ = (Integer)arguments2Value;
                        if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_)) {
                            this.int32ArrayObjObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                            this.state_ = state |= 0x40;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doInt32ArrayObjObjIdx(arguments0Value_, arguments1Value, arguments2Value_, this.int32ArrayObjObjIdx_toIndexNode_);
                            return object;
                        }
                    }
                    if (AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value_) || AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value_)) {
                        this.bigInt64ArrayObjObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                        this.state_ = state |= 0x80;
                        lock.unlock();
                        hasLock = false;
                        Object object = this.doBigInt64ArrayObjObjIdx(arguments0Value_, arguments1Value, arguments2Value, this.bigInt64ArrayObjObjIdx_toIndexNode_);
                        return object;
                    }
                }
                this.generic_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                Object object = this.doGeneric(arguments0Value, arguments1Value, arguments2Value, this.generic_toIndexNode_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if ((state & 0x1FF) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & 0x1FF & (state & 0x1FF) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<JSToIndexNode>> cached;
            Object[] data = new Object[10];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doIntArrayObj";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doIntArrayObj";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "doInt16ArrayObj";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "doInt16ArrayObj";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayObj";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayObj";
            s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayObjObjIdx";
            if ((state & 0x40) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<JSToIndexNode>>();
                cached.add(Arrays.asList(this.int32ArrayObjObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[7] = s;
            s = new Object[3];
            s[0] = "doBigInt64ArrayObjObjIdx";
            if ((state & 0x80) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.bigInt64ArrayObjObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[8] = s;
            s = new Object[3];
            s[0] = "doGeneric";
            if ((state & 0x100) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.generic_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[9] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static AtomicsBuiltins.AtomicsStoreNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new AtomicsStoreNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=AtomicsBuiltins.AtomicsLoadNode.class)
    public static final class AtomicsLoadNodeGen
    extends AtomicsBuiltins.AtomicsLoadNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToIndexNode int32ArrayObjObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode generic_toIndexNode_;

        private AtomicsLoadNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object executeWithBufferAndIndex(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
            int state = this.state_;
            if ((state & 0x1FF) != 0 && JSTypes.isDynamicObject(arguments0Value)) {
                DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                if ((state & 0xFF) != 0 && arguments1Value instanceof Integer) {
                    int arguments1Value_ = (Integer)arguments1Value;
                    if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                        return this.doInt8ArrayObj(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                        return this.doUint8ArrayObj(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                        return this.doInt16ArrayObj(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                        return this.doUint16ArrayObj(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                        return this.doInt32ArrayObj(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 0x20) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                        return this.doUint32ArrayObj(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 0x40) != 0 && AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                        return this.doBigInt64ArrayObj(arguments0Value_, arguments1Value_);
                    }
                    if ((state & 0x80) != 0 && AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                        return this.doBigUint64ArrayObj(arguments0Value_, arguments1Value_);
                    }
                }
                if ((state & 0x100) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_)) {
                    return this.doInt32ArrayObjObjIdx(arguments0Value_, arguments1Value, this.int32ArrayObjObjIdx_toIndexNode_);
                }
            }
            if ((state & 0x200) != 0) {
                return this.doGeneric(arguments0Value, arguments1Value, this.generic_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value, arguments1Value);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x300) == 0 && state != 0) {
                return this.execute_int0(frameValue, state);
            }
            return this.execute_generic1(frameValue, state);
        }

        private Object execute_int0(VirtualFrame frameValue, int state) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, ex.getResult());
            }
            if ((state & 0xFF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt8ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint8ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt16ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint16ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt32ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 0x20) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint32ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 0x40) != 0 && AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doBigInt64ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 0x80) != 0 && AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doBigUint64ArrayObj(arguments0Value__, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object execute_generic1(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0x1FF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 0xFF) != 0 && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doInt8ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doUint8ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doInt16ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doUint16ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doInt32ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 0x20) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doUint32ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 0x40) != 0 && AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doBigInt64ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 0x80) != 0 && AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doBigUint64ArrayObj(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 0x100) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                    return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, this.int32ArrayObjObjIdx_toIndexNode_);
                }
            }
            if ((state & 0x200) != 0) {
                return this.doGeneric(arguments0Value_, arguments1Value_, this.generic_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 0x200) != 0) {
                return JSTypesGen.expectInteger(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0x100) == 0 && (state & 0x11F) != 0) {
                return this.executeInt_int2(frameValue, state, arguments0Value_);
            }
            return this.executeInt_generic3(frameValue, state, arguments0Value_);
        }

        private int executeInt_int2(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            int arguments1Value_;
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult()));
            }
            if ((state & 0x1F) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt8ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint8ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt16ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint16ArrayObj(arguments0Value__, arguments1Value_);
                }
                if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt32ArrayObj(arguments0Value__, arguments1Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        private int executeInt_generic3(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if ((state & 0x11F) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 0x1F) != 0 && arguments1Value_ instanceof Integer) {
                    int arguments1Value__ = (Integer)arguments1Value_;
                    if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doInt8ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doUint8ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doInt16ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doUint16ArrayObj(arguments0Value__, arguments1Value__);
                    }
                    if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value__)) {
                        return this.doInt32ArrayObj(arguments0Value__, arguments1Value__);
                    }
                }
                if ((state & 0x100) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                    return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, this.int32ArrayObjObjIdx_toIndexNode_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 0x2E0) == 0 && state != 0) {
                    this.executeInt(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments1Value instanceof Integer) {
                        int arguments1Value_ = (Integer)arguments1Value;
                        if (AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                            this.state_ = state |= 1;
                            lock.unlock();
                            hasLock = false;
                            Integer n = this.doInt8ArrayObj(arguments0Value_, arguments1Value_);
                            return n;
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                            this.state_ = state |= 2;
                            lock.unlock();
                            hasLock = false;
                            Integer n = this.doUint8ArrayObj(arguments0Value_, arguments1Value_);
                            return n;
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                            this.state_ = state |= 4;
                            lock.unlock();
                            hasLock = false;
                            Integer n = this.doInt16ArrayObj(arguments0Value_, arguments1Value_);
                            return n;
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                            this.state_ = state |= 8;
                            lock.unlock();
                            hasLock = false;
                            Integer n = this.doUint16ArrayObj(arguments0Value_, arguments1Value_);
                            return n;
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                            this.state_ = state |= 0x10;
                            lock.unlock();
                            hasLock = false;
                            Integer n = this.doInt32ArrayObj(arguments0Value_, arguments1Value_);
                            return n;
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                            this.state_ = state |= 0x20;
                            lock.unlock();
                            hasLock = false;
                            LargeInteger largeInteger = this.doUint32ArrayObj(arguments0Value_, arguments1Value_);
                            return largeInteger;
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                            this.state_ = state |= 0x40;
                            lock.unlock();
                            hasLock = false;
                            BigInt bigInt = this.doBigInt64ArrayObj(arguments0Value_, arguments1Value_);
                            return bigInt;
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, arguments1Value_)) {
                            this.state_ = state |= 0x80;
                            lock.unlock();
                            hasLock = false;
                            BigInt bigInt = this.doBigUint64ArrayObj(arguments0Value_, arguments1Value_);
                            return bigInt;
                        }
                    }
                    if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_)) {
                        this.int32ArrayObjObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                        this.state_ = state |= 0x100;
                        lock.unlock();
                        hasLock = false;
                        Integer n = this.doInt32ArrayObjObjIdx(arguments0Value_, arguments1Value, this.int32ArrayObjObjIdx_toIndexNode_);
                        return n;
                    }
                }
                this.generic_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                Object object = this.doGeneric(arguments0Value, arguments1Value, this.generic_toIndexNode_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<JSToIndexNode>> cached;
            Object[] data = new Object[11];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doInt8ArrayObj";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doUint8ArrayObj";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "doInt16ArrayObj";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "doUint16ArrayObj";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayObj";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "doUint32ArrayObj";
            s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            s = new Object[3];
            s[0] = "doBigInt64ArrayObj";
            s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[7] = s;
            s = new Object[3];
            s[0] = "doBigUint64ArrayObj";
            s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[8] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayObjObjIdx";
            if ((state & 0x100) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<JSToIndexNode>>();
                cached.add(Arrays.asList(this.int32ArrayObjObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[9] = s;
            s = new Object[3];
            s[0] = "doGeneric";
            if ((state & 0x200) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.generic_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[10] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static AtomicsBuiltins.AtomicsLoadNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new AtomicsLoadNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=AtomicsBuiltins.AtomicsCompareExchangeNode.class)
    public static final class AtomicsCompareExchangeNodeGen
    extends AtomicsBuiltins.AtomicsCompareExchangeNode
    implements Introspection.Provider {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @Node.Child
        private JavaScriptNode arguments2_;
        @Node.Child
        private JavaScriptNode arguments3_;
        @CompilerDirectives.CompilationFinal
        private int state_;
        @Node.Child
        private JSToIndexNode int32ArrayByteObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode int32ArrayIntObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode int32ArrayObjObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode bigInt64ArrayObjObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode bigUint64ArrayObjObjIdx_toIndexNode_;
        @Node.Child
        private JSToIndexNode generic_toIndexNode_;

        private AtomicsCompareExchangeNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
            this.arguments3_ = arguments != null && 3 < arguments.length ? arguments[3] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state = this.state_;
            if ((state & 0x3FB0) == 0 && state != 0) {
                return this.execute_int_int_int0(frameValue, state);
            }
            if ((state & 0x3FDF) == 0 && state != 0) {
                return this.execute_int_byte_byte1(frameValue, state);
            }
            if ((state & 0x3EFF) == 0 && state != 0) {
                return this.execute_byte_byte2(frameValue, state);
            }
            if ((state & 0x3DFF) == 0 && state != 0) {
                return this.execute_int_int3(frameValue, state);
            }
            if ((state & 0x3F0F) == 0 && state != 0) {
                return this.execute_int4(frameValue, state);
            }
            return this.execute_generic5(frameValue, state);
        }

        private Object execute_int_int_int0(VirtualFrame frameValue, int state) {
            int arguments3Value_;
            int arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
            }
            try {
                arguments3Value_ = this.arguments3_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
            }
            if ((state & 0x4F) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt8ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint8ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt16ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint16ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                if ((state & 0x40) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt32ArrayInt(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        private Object execute_int_byte_byte1(VirtualFrame frameValue, int state) {
            DynamicObject arguments0Value__;
            byte arguments3Value_;
            byte arguments2Value_;
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
            }
            try {
                arguments2Value_ = this.arguments2_.executeByte(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
            }
            try {
                arguments3Value_ = this.arguments3_.executeByte(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
            }
            assert ((state & 0x20) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                return this.doInt32ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        private Object execute_byte_byte2(VirtualFrame frameValue, int state) {
            DynamicObject arguments0Value__;
            byte arguments3Value_;
            byte arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeByte(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
            }
            try {
                arguments3Value_ = this.arguments3_.executeByte(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
            }
            assert ((state & 0x100) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doInt32ArrayByteObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, this.int32ArrayByteObjIdx_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        private Object execute_int_int3(VirtualFrame frameValue, int state) {
            DynamicObject arguments0Value__;
            int arguments3Value_;
            int arguments2Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value);
            }
            try {
                arguments3Value_ = this.arguments3_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult());
            }
            assert ((state & 0x200) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doInt32ArrayIntObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, this.int32ArrayIntObjIdx_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        private Object execute_int4(VirtualFrame frameValue, int state) {
            int arguments1Value_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value, arguments3Value);
            }
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            if ((state & 0xF0) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint32ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                if ((state & 0x20) != 0 && arguments2Value_ instanceof Byte) {
                    byte by = (Byte)arguments2Value_;
                    if (arguments3Value_ instanceof Byte) {
                        byte by2 = (Byte)arguments3Value_;
                        if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                            return this.doInt32ArrayByte(arguments0Value__, arguments1Value_, by, by2);
                        }
                    }
                }
                if ((state & 0x40) != 0 && arguments2Value_ instanceof Integer) {
                    int n = (Integer)arguments2Value_;
                    if (arguments3Value_ instanceof Integer) {
                        int n2 = (Integer)arguments3Value_;
                        if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                            return this.doInt32ArrayInt(arguments0Value__, arguments1Value_, n, n2);
                        }
                    }
                }
                if ((state & 0x80) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt32ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        private Object execute_generic5(VirtualFrame frameValue, int state) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            if ((state & 0x1FFF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 0xFF) != 0 && arguments1Value_ instanceof Integer) {
                    int n = (Integer)arguments1Value_;
                    if ((state & 0xF) != 0 && arguments2Value_ instanceof Integer) {
                        int n2 = (Integer)arguments2Value_;
                        if (arguments3Value_ instanceof Integer) {
                            int n3 = (Integer)arguments3Value_;
                            if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doInt8ArrayByte(arguments0Value__, n, n2, n3);
                            }
                            if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doUint8ArrayByte(arguments0Value__, n, n2, n3);
                            }
                            if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doInt16ArrayByte(arguments0Value__, n, n2, n3);
                            }
                            if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doUint16ArrayByte(arguments0Value__, n, n2, n3);
                            }
                        }
                    }
                    if ((state & 0x10) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                        return this.doUint32ArrayByte(arguments0Value__, n, arguments2Value_, arguments3Value_);
                    }
                    if ((state & 0x20) != 0 && arguments2Value_ instanceof Byte) {
                        byte by = (Byte)arguments2Value_;
                        if (arguments3Value_ instanceof Byte) {
                            byte by2 = (Byte)arguments3Value_;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doInt32ArrayByte(arguments0Value__, n, by, by2);
                            }
                        }
                    }
                    if ((state & 0x40) != 0 && arguments2Value_ instanceof Integer) {
                        int n4 = (Integer)arguments2Value_;
                        if (arguments3Value_ instanceof Integer) {
                            int n5 = (Integer)arguments3Value_;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doInt32ArrayInt(arguments0Value__, n, n4, n5);
                            }
                        }
                    }
                    if ((state & 0x80) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                        return this.doInt32ArrayObj(arguments0Value__, n, arguments2Value_, arguments3Value_);
                    }
                }
                if ((state & 0x1F00) != 0) {
                    if ((state & 0x100) != 0 && arguments2Value_ instanceof Byte) {
                        byte by = (Byte)arguments2Value_;
                        if (arguments3Value_ instanceof Byte) {
                            byte by3 = (Byte)arguments3Value_;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                                return this.doInt32ArrayByteObjIdx(arguments0Value__, arguments1Value_, by, by3, this.int32ArrayByteObjIdx_toIndexNode_);
                            }
                        }
                    }
                    if ((state & 0x200) != 0 && arguments2Value_ instanceof Integer) {
                        int n = (Integer)arguments2Value_;
                        if (arguments3Value_ instanceof Integer) {
                            int n6 = (Integer)arguments3Value_;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                                return this.doInt32ArrayIntObjIdx(arguments0Value__, arguments1Value_, n, n6, this.int32ArrayIntObjIdx_toIndexNode_);
                            }
                        }
                    }
                    if ((state & 0x1C00) != 0) {
                        if ((state & 0x400) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                            return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, this.int32ArrayObjObjIdx_toIndexNode_);
                        }
                        if ((state & 0x800) != 0 && AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value__)) {
                            return this.doBigInt64ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, this.bigInt64ArrayObjObjIdx_toIndexNode_);
                        }
                        if ((state & 0x1000) != 0 && AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value__)) {
                            return this.doBigUint64ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, this.bigUint64ArrayObjObjIdx_toIndexNode_);
                        }
                    }
                }
            }
            if ((state & 0x2000) != 0) {
                return this.doGeneric(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, this.generic_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 0x2010) != 0) {
                return JSTypesGen.expectInteger(this.execute(frameValue));
            }
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if ((state & 0x7A0) == 0 && (state & 0x7EF) != 0) {
                return this.executeInt_int_int_int6(frameValue, state, arguments0Value_);
            }
            if ((state & 0x7CF) == 0 && (state & 0x7EF) != 0) {
                return this.executeInt_int_byte_byte7(frameValue, state, arguments0Value_);
            }
            if ((state & 0x6EF) == 0 && (state & 0x7EF) != 0) {
                return this.executeInt_byte_byte8(frameValue, state, arguments0Value_);
            }
            if ((state & 0x5EF) == 0 && (state & 0x7EF) != 0) {
                return this.executeInt_int_int9(frameValue, state, arguments0Value_);
            }
            if ((state & 0x76F) == 0 && (state & 0x7EF) != 0) {
                return this.executeInt_int10(frameValue, state, arguments0Value_);
            }
            return this.executeInt_generic11(frameValue, state, arguments0Value_);
        }

        private int executeInt_int_int_int6(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            int arguments3Value_;
            int arguments2Value_;
            int arguments1Value_;
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
            }
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
            }
            try {
                arguments3Value_ = this.arguments3_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
            }
            if ((state & 0x4F) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt8ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint8ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt16ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doUint16ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
                if ((state & 0x40) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                    return this.doInt32ArrayInt(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
        }

        private int executeInt_int_byte_byte7(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            DynamicObject arguments0Value__;
            byte arguments3Value_;
            byte arguments2Value_;
            int arguments1Value_;
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
            }
            try {
                arguments2Value_ = this.arguments2_.executeByte(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
            }
            try {
                arguments3Value_ = this.arguments3_.executeByte(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
            }
            assert ((state & 0x20) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                return this.doInt32ArrayByte(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
        }

        private int executeInt_byte_byte8(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            DynamicObject arguments0Value__;
            byte arguments3Value_;
            byte arguments2Value_;
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeByte(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
            }
            try {
                arguments3Value_ = this.arguments3_.executeByte(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
            }
            assert ((state & 0x100) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doInt32ArrayByteObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, this.int32ArrayByteObjIdx_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
        }

        private int executeInt_int_int9(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            DynamicObject arguments0Value__;
            int arguments3Value_;
            int arguments2Value_;
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            try {
                arguments2Value_ = this.arguments2_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, ex.getResult(), arguments3Value));
            }
            try {
                arguments3Value_ = this.arguments3_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, ex.getResult()));
            }
            assert ((state & 0x200) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_)) {
                return this.doInt32ArrayIntObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, this.int32ArrayIntObjIdx_toIndexNode_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
        }

        private int executeInt_int10(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            DynamicObject arguments0Value__;
            int arguments1Value_;
            try {
                arguments1Value_ = this.arguments1_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object arguments2Value = this.arguments2_.execute(frameValue);
                Object arguments3Value = this.arguments3_.execute(frameValue);
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, ex.getResult(), arguments2Value, arguments3Value));
            }
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            assert ((state & 0x80) != 0);
            if (JSTypes.isDynamicObject(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__ = (DynamicObject)arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, arguments1Value_)) {
                return this.doInt32ArrayObj(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
        }

        private int executeInt_generic11(VirtualFrame frameValue, int state, Object arguments0Value_) throws UnexpectedResultException {
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            Object arguments2Value_ = this.arguments2_.execute(frameValue);
            Object arguments3Value_ = this.arguments3_.execute(frameValue);
            if ((state & 0x7EF) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
                DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
                if ((state & 0xEF) != 0 && arguments1Value_ instanceof Integer) {
                    int n = (Integer)arguments1Value_;
                    if ((state & 0xF) != 0 && arguments2Value_ instanceof Integer) {
                        int n2 = (Integer)arguments2Value_;
                        if (arguments3Value_ instanceof Integer) {
                            int n3 = (Integer)arguments3Value_;
                            if ((state & 1) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doInt8ArrayByte(arguments0Value__, n, n2, n3);
                            }
                            if ((state & 2) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doUint8ArrayByte(arguments0Value__, n, n2, n3);
                            }
                            if ((state & 4) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doInt16ArrayByte(arguments0Value__, n, n2, n3);
                            }
                            if ((state & 8) != 0 && AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doUint16ArrayByte(arguments0Value__, n, n2, n3);
                            }
                        }
                    }
                    if ((state & 0x20) != 0 && arguments2Value_ instanceof Byte) {
                        byte by = (Byte)arguments2Value_;
                        if (arguments3Value_ instanceof Byte) {
                            byte by2 = (Byte)arguments3Value_;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doInt32ArrayByte(arguments0Value__, n, by, by2);
                            }
                        }
                    }
                    if ((state & 0x40) != 0 && arguments2Value_ instanceof Integer) {
                        int n4 = (Integer)arguments2Value_;
                        if (arguments3Value_ instanceof Integer) {
                            int n5 = (Integer)arguments3Value_;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                                return this.doInt32ArrayInt(arguments0Value__, n, n4, n5);
                            }
                        }
                    }
                    if ((state & 0x80) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value__, n)) {
                        return this.doInt32ArrayObj(arguments0Value__, n, arguments2Value_, arguments3Value_);
                    }
                }
                if ((state & 0x700) != 0) {
                    if ((state & 0x100) != 0 && arguments2Value_ instanceof Byte) {
                        byte by = (Byte)arguments2Value_;
                        if (arguments3Value_ instanceof Byte) {
                            byte by3 = (Byte)arguments3Value_;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                                return this.doInt32ArrayByteObjIdx(arguments0Value__, arguments1Value_, by, by3, this.int32ArrayByteObjIdx_toIndexNode_);
                            }
                        }
                    }
                    if ((state & 0x200) != 0 && arguments2Value_ instanceof Integer) {
                        int n = (Integer)arguments2Value_;
                        if (arguments3Value_ instanceof Integer) {
                            int n6 = (Integer)arguments3Value_;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                                return this.doInt32ArrayIntObjIdx(arguments0Value__, arguments1Value_, n, n6, this.int32ArrayIntObjIdx_toIndexNode_);
                            }
                        }
                    }
                    if ((state & 0x400) != 0 && AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value__)) {
                        return this.doInt32ArrayObjObjIdx(arguments0Value__, arguments1Value_, arguments2Value_, arguments3Value_, this.int32ArrayObjObjIdx_toIndexNode_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_));
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            int state = this.state_;
            try {
                if ((state & 0x3810) == 0 && state != 0) {
                    this.executeInt(frameValue);
                    return;
                }
                this.execute(frameValue);
                return;
            }
            catch (UnexpectedResultException ex) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            try {
                if (JSTypes.isDynamicObject(arguments0Value)) {
                    DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                    if (arguments1Value instanceof Integer) {
                        int n = (Integer)arguments1Value;
                        if (arguments2Value instanceof Integer) {
                            int n2 = (Integer)arguments2Value;
                            if (arguments3Value instanceof Integer) {
                                int n3 = (Integer)arguments3Value;
                                if (AtomicsBuiltins.AtomicsOperationNode.isInt8SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, n)) {
                                    this.state_ = state |= 1;
                                    lock.unlock();
                                    hasLock = false;
                                    Integer n4 = this.doInt8ArrayByte(arguments0Value_, n, n2, n3);
                                    return n4;
                                }
                                if (AtomicsBuiltins.AtomicsOperationNode.isUint8SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, n)) {
                                    this.state_ = state |= 2;
                                    lock.unlock();
                                    hasLock = false;
                                    Integer n5 = this.doUint8ArrayByte(arguments0Value_, n, n2, n3);
                                    return n5;
                                }
                                if (AtomicsBuiltins.AtomicsOperationNode.isInt16SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, n)) {
                                    this.state_ = state |= 4;
                                    lock.unlock();
                                    hasLock = false;
                                    Integer n6 = this.doInt16ArrayByte(arguments0Value_, n, n2, n3);
                                    return n6;
                                }
                                if (AtomicsBuiltins.AtomicsOperationNode.isUint16SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, n)) {
                                    this.state_ = state |= 8;
                                    lock.unlock();
                                    hasLock = false;
                                    Integer n7 = this.doUint16ArrayByte(arguments0Value_, n, n2, n3);
                                    return n7;
                                }
                            }
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isUint32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, n)) {
                            this.state_ = state |= 0x10;
                            lock.unlock();
                            hasLock = false;
                            Object object = this.doUint32ArrayByte(arguments0Value_, n, arguments2Value, arguments3Value);
                            return object;
                        }
                        if (arguments2Value instanceof Byte) {
                            byte by = (Byte)arguments2Value;
                            if (arguments3Value instanceof Byte) {
                                byte by2 = (Byte)arguments3Value;
                                if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, n)) {
                                    this.state_ = state |= 0x20;
                                    lock.unlock();
                                    hasLock = false;
                                    Integer n8 = this.doInt32ArrayByte(arguments0Value_, n, by, by2);
                                    return n8;
                                }
                            }
                        }
                        if (arguments2Value instanceof Integer) {
                            int n9 = (Integer)arguments2Value;
                            if (arguments3Value instanceof Integer) {
                                int n10 = (Integer)arguments3Value;
                                if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, n)) {
                                    this.state_ = state |= 0x40;
                                    lock.unlock();
                                    hasLock = false;
                                    Integer n11 = this.doInt32ArrayInt(arguments0Value_, n, n9, n10);
                                    return n11;
                                }
                            }
                        }
                        if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_) && AtomicsBuiltins.AtomicsOperationNode.inboundFast(arguments0Value_, n)) {
                            this.state_ = state |= 0x80;
                            lock.unlock();
                            hasLock = false;
                            Integer n12 = this.doInt32ArrayObj(arguments0Value_, n, arguments2Value, arguments3Value);
                            return n12;
                        }
                    }
                    if (arguments2Value instanceof Byte) {
                        byte n = (Byte)arguments2Value;
                        if (arguments3Value instanceof Byte) {
                            byte by = (Byte)arguments3Value;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_)) {
                                this.int32ArrayByteObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                                this.state_ = state |= 0x100;
                                lock.unlock();
                                hasLock = false;
                                Integer n13 = this.doInt32ArrayByteObjIdx(arguments0Value_, arguments1Value, n, by, this.int32ArrayByteObjIdx_toIndexNode_);
                                return n13;
                            }
                        }
                    }
                    if (arguments2Value instanceof Integer) {
                        int bigInt = (Integer)arguments2Value;
                        if (arguments3Value instanceof Integer) {
                            int n = (Integer)arguments3Value;
                            if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_)) {
                                this.int32ArrayIntObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                                this.state_ = state |= 0x200;
                                lock.unlock();
                                hasLock = false;
                                Integer n14 = this.doInt32ArrayIntObjIdx(arguments0Value_, arguments1Value, bigInt, n, this.int32ArrayIntObjIdx_toIndexNode_);
                                return n14;
                            }
                        }
                    }
                    if (AtomicsBuiltins.AtomicsOperationNode.isInt32SharedBufferView(arguments0Value_)) {
                        this.int32ArrayObjObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                        this.state_ = state |= 0x400;
                        lock.unlock();
                        hasLock = false;
                        Integer bigInt = this.doInt32ArrayObjObjIdx(arguments0Value_, arguments1Value, arguments2Value, arguments3Value, this.int32ArrayObjObjIdx_toIndexNode_);
                        return bigInt;
                    }
                    if (AtomicsBuiltins.AtomicsOperationNode.isBigInt64SharedBufferView(arguments0Value_)) {
                        this.bigInt64ArrayObjObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                        this.state_ = state |= 0x800;
                        lock.unlock();
                        hasLock = false;
                        BigInt bigInt = this.doBigInt64ArrayObjObjIdx(arguments0Value_, arguments1Value, arguments2Value, arguments3Value, this.bigInt64ArrayObjObjIdx_toIndexNode_);
                        return bigInt;
                    }
                    if (AtomicsBuiltins.AtomicsOperationNode.isBigUint64SharedBufferView(arguments0Value_)) {
                        this.bigUint64ArrayObjObjIdx_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                        this.state_ = state |= 0x1000;
                        lock.unlock();
                        hasLock = false;
                        BigInt bigInt = this.doBigUint64ArrayObjObjIdx(arguments0Value_, arguments1Value, arguments2Value, arguments3Value, this.bigUint64ArrayObjObjIdx_toIndexNode_);
                        return bigInt;
                    }
                }
                this.generic_toIndexNode_ = (JSToIndexNode)super.insert((Node)JSToIndexNode.create());
                this.state_ = state |= 0x2000;
                lock.unlock();
                hasLock = false;
                Object object = this.doGeneric(arguments0Value, arguments1Value, arguments2Value, arguments3Value, this.generic_toIndexNode_);
                return object;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<JSToIndexNode>> cached;
            Object[] data = new Object[15];
            data[0] = 0;
            int state = this.state_;
            Object[] s = new Object[3];
            s[0] = "doInt8ArrayByte";
            s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[1] = s;
            s = new Object[3];
            s[0] = "doUint8ArrayByte";
            s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[2] = s;
            s = new Object[3];
            s[0] = "doInt16ArrayByte";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[3] = s;
            s = new Object[3];
            s[0] = "doUint16ArrayByte";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            s = new Object[3];
            s[0] = "doUint32ArrayByte";
            s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[5] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayByte";
            s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[6] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayInt";
            s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[7] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayObj";
            s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[8] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayByteObjIdx";
            if ((state & 0x100) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<JSToIndexNode>>();
                cached.add(Arrays.asList(this.int32ArrayByteObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[9] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayIntObjIdx";
            if ((state & 0x200) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.int32ArrayIntObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[10] = s;
            s = new Object[3];
            s[0] = "doInt32ArrayObjObjIdx";
            if ((state & 0x400) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.int32ArrayObjObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[11] = s;
            s = new Object[3];
            s[0] = "doBigInt64ArrayObjObjIdx";
            if ((state & 0x800) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.bigInt64ArrayObjObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[12] = s;
            s = new Object[3];
            s[0] = "doBigUint64ArrayObjObjIdx";
            if ((state & 0x1000) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.bigUint64ArrayObjObjIdx_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[13] = s;
            s = new Object[3];
            s[0] = "doGeneric";
            if ((state & 0x2000) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.generic_toIndexNode_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[14] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static AtomicsBuiltins.AtomicsCompareExchangeNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new AtomicsCompareExchangeNodeGen(context, builtin, arguments);
        }
    }
}

