/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.StringIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class StringIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<StringIteratorPrototype> {
    protected StringIteratorPrototypeBuiltins() {
        super("String Iterator.prototype", StringIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, StringIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return StringIteratorPrototypeBuiltinsFactory.StringIteratorNextNodeGen.create(context, builtin, StringIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class StringIteratorNextNode
    extends JSBuiltinNode {
        @Node.Child
        private HasHiddenKeyCacheNode isStringIteratorNode;
        @Node.Child
        private PropertyGetNode getIteratedObjectNode;
        @Node.Child
        private PropertyGetNode getNextIndexNode;
        @Node.Child
        private PropertySetNode setNextIndexNode;
        @Node.Child
        private PropertySetNode setIteratedObjectNode;
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;
        private final ConditionProfile isSingleChar = ConditionProfile.createCountingProfile();
        private final ConditionProfile isLowSurrogate = ConditionProfile.createCountingProfile();

        public StringIteratorNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.isStringIteratorNode = HasHiddenKeyCacheNode.create(JSString.ITERATED_STRING_ID);
            this.getIteratedObjectNode = PropertyGetNode.createGetHidden(JSString.ITERATED_STRING_ID, context);
            this.getNextIndexNode = PropertyGetNode.createGetHidden(JSString.STRING_ITERATOR_NEXT_INDEX_ID, context);
            this.setIteratedObjectNode = PropertySetNode.createSetHidden(JSString.ITERATED_STRING_ID, context);
            this.setNextIndexNode = PropertySetNode.createSetHidden(JSString.STRING_ITERATOR_NEXT_INDEX_ID, context);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        }

        @Specialization(guards={"isStringIterator(iterator)"})
        protected DynamicObject doStringIterator(VirtualFrame frame, DynamicObject iterator) {
            char second;
            int length;
            Object iteratedString = this.getIteratedObjectNode.getValue(iterator);
            if (iteratedString == Undefined.instance) {
                return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            String string = (String)iteratedString;
            int index = this.getNextIndex(iterator);
            if (index >= (length = string.length())) {
                this.setIteratedObjectNode.setValue(iterator, Undefined.instance);
                return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            char first = string.charAt(index);
            String result = this.isSingleChar.profile(!Character.isHighSurrogate(first) || index + 1 == length) ? String.valueOf(first) : (this.isLowSurrogate.profile(Character.isLowSurrogate(second = string.charAt(index + 1))) ? new String(new char[]{first, second}) : String.valueOf(first));
            this.setNextIndexNode.setValue(iterator, index + result.length());
            return this.createIterResultObjectNode.execute(frame, result, false);
        }

        @Fallback
        protected DynamicObject doIncompatibleReceiver(Object iterator) {
            throw Errors.createTypeError("not a String Iterator");
        }

        protected final boolean isStringIterator(Object thisObj) {
            return this.isStringIteratorNode.executeHasHiddenKey(thisObj);
        }

        private int getNextIndex(DynamicObject iterator) {
            try {
                return this.getNextIndexNode.getValueInt(iterator);
            }
            catch (UnexpectedResultException e) {
                throw Errors.shouldNotReachHere();
            }
        }
    }

    public static enum StringIteratorPrototype implements BuiltinEnum<StringIteratorPrototype>
    {
        next(0);

        private final int length;

        private StringIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

