/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNodeFactory;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSDictionaryObject;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;

public abstract class CreateObjectNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    protected CreateObjectNode(JSContext context) {
        this.context = context;
    }

    public static CreateObjectNode create(JSContext context) {
        return new CreateOrdinaryObjectNode(context);
    }

    public static CreateObjectWithPrototypeNode createWithPrototype(JSContext context, JavaScriptNode prototypeExpression) {
        return CreateObjectNode.createWithPrototype(context, prototypeExpression, JSUserObject.INSTANCE);
    }

    public static CreateObjectWithPrototypeNode createWithPrototype(JSContext context, JavaScriptNode prototypeExpression, JSClass jsclass) {
        return CreateObjectWithCachedPrototypeNode.create(context, prototypeExpression, jsclass);
    }

    static CreateObjectNode createDictionary(JSContext context) {
        return new CreateDictionaryObjectNode(context);
    }

    public final DynamicObject execute(VirtualFrame frame) {
        return this.executeDynamicObject(frame);
    }

    public abstract DynamicObject executeDynamicObject(VirtualFrame var1);

    protected abstract CreateObjectNode copyUninitialized();

    final JSContext getContext() {
        return this.context;
    }

    private static class CreateDictionaryObjectNode
    extends CreateObjectNode {
        protected CreateDictionaryObjectNode(JSContext context) {
            super(context);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frame) {
            return JSDictionaryObject.create(this.context);
        }

        @Override
        protected CreateObjectNode copyUninitialized() {
            return new CreateDictionaryObjectNode(this.context);
        }
    }

    protected static abstract class CreateObjectWithCachedPrototypeNode
    extends CreateObjectWithPrototypeNode {
        protected final JSClass jsclass;

        protected CreateObjectWithCachedPrototypeNode(JSContext context, JavaScriptNode prototypeExpression, JSClass jsclass) {
            super(context, prototypeExpression);
            this.jsclass = jsclass;
        }

        protected static CreateObjectWithPrototypeNode create(JSContext context, JavaScriptNode prototypeExpression, JSClass jsclass) {
            return CreateObjectNodeFactory.CreateObjectWithCachedPrototypeNodeGen.create(context, prototypeExpression, jsclass);
        }

        @Specialization(guards={"!context.isMultiContext()", "isValidPrototype(cachedPrototype)", "prototype == cachedPrototype"}, limit="1")
        final DynamicObject doCachedPrototype(DynamicObject prototype, @Cached(value="prototype") DynamicObject cachedPrototype, @Cached(value="getProtoChildShape(cachedPrototype)") Shape protoChildShape) {
            return JSObject.create(this.context, protoChildShape);
        }

        @Specialization(guards={"isOrdinaryObject()", "isValidPrototype(prototype)"}, replaces={"doCachedPrototype"})
        final DynamicObject doOrdinaryInstancePrototype(DynamicObject prototype) {
            return JSUserObject.createWithPrototypeInObject(prototype, this.context);
        }

        @Specialization(guards={"isPromiseObject()", "isValidPrototype(prototype)"}, replaces={"doCachedPrototype"})
        final DynamicObject doPromiseInstancePrototype(DynamicObject prototype) {
            return JSPromise.createWithPrototypeInObject(prototype, this.context);
        }

        @Specialization(guards={"!isOrdinaryObject()", "!isPromiseObject()", "isValidPrototype(prototype)"}, replaces={"doCachedPrototype"})
        final DynamicObject doUncachedPrototype(DynamicObject prototype) {
            return JSObject.create(this.context, prototype, this.jsclass);
        }

        @Specialization(guards={"!isValidPrototype(prototype)"})
        final DynamicObject doNotJSObjectOrNull(Object prototype) {
            return JSUserObject.create(this.context);
        }

        final Shape getProtoChildShape(DynamicObject prototype) {
            return prototype == Null.instance ? this.context.getEmptyShapeNullPrototype() : JSObjectUtil.getProtoChildShape(prototype, this.jsclass, this.context);
        }

        final boolean isOrdinaryObject() {
            return this.jsclass == JSUserObject.INSTANCE;
        }

        final boolean isPromiseObject() {
            return this.jsclass == JSPromise.INSTANCE;
        }

        @Override
        protected CreateObjectWithPrototypeNode copyUninitialized() {
            return CreateObjectWithCachedPrototypeNode.create(this.context, JavaScriptNode.cloneUninitialized(this.prototypeExpression), this.jsclass);
        }
    }

    public static abstract class CreateObjectWithPrototypeNode
    extends CreateObjectNode {
        @Node.Child
        @Executed
        protected JavaScriptNode prototypeExpression;

        protected CreateObjectWithPrototypeNode(JSContext context, JavaScriptNode prototypeExpression) {
            super(context);
            this.prototypeExpression = prototypeExpression;
        }

        public abstract DynamicObject executeDynamicObject(VirtualFrame var1, DynamicObject var2);

        @Override
        protected abstract CreateObjectWithPrototypeNode copyUninitialized();
    }

    private static class CreateOrdinaryObjectNode
    extends CreateObjectNode {
        protected CreateOrdinaryObjectNode(JSContext context) {
            super(context);
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frame) {
            return JSUserObject.create(this.context);
        }

        @Override
        protected CreateObjectNode copyUninitialized() {
            return new CreateOrdinaryObjectNode(this.context);
        }
    }
}

