/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.TokenType;
import com.oracle.js.parser.ir.BinaryNode;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.LiteralNode;
import com.oracle.js.parser.ir.UnaryNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.binary.JSEqualNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.nodes.binary.JSTypeofIdenticalNodeGen;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.nodes.unary.TypeOfNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

@ImportStatic(value={Type.class})
public abstract class JSTypeofIdenticalNode
extends JSUnaryNode {
    private final Type type;

    protected JSTypeofIdenticalNode(JavaScriptNode childNode, Type type) {
        super(childNode);
        this.type = type;
    }

    public static JSTypeofIdenticalNode create(JavaScriptNode childNode, JSConstantNode.JSConstantStringNode constStringNode) {
        return JSTypeofIdenticalNode.create(childNode, (String)constStringNode.execute(null));
    }

    public static JSTypeofIdenticalNode create(JavaScriptNode childNode, String string) {
        return JSTypeofIdenticalNodeGen.create(childNode, JSTypeofIdenticalNode.typeStringToEnum(string));
    }

    private static Type typeStringToEnum(String string) {
        switch (string) {
            case "number": {
                return Type.Number;
            }
            case "bigint": {
                return Type.BigInt;
            }
            case "string": {
                return Type.String;
            }
            case "boolean": {
                return Type.Boolean;
            }
            case "object": {
                return Type.Object;
            }
            case "undefined": {
                return Type.Undefined;
            }
            case "function": {
                return Type.Function;
            }
            case "symbol": {
                return Type.Symbol;
            }
        }
        return Type.False;
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.BinaryOperationTag.class || tag == JSTags.UnaryOperationTag.class || tag == JSTags.LiteralTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.BinaryOperationTag.class) || materializedTags.contains(JSTags.UnaryOperationTag.class) || materializedTags.contains(JSTags.LiteralTag.class)) {
            Object[] info = this.parseMaterializationInfo();
            if (info == null) {
                info = new Object[]{this.type.name().toLowerCase(), true, true};
            }
            JavaScriptNode lhs = JSConstantNode.create(info[0]);
            JavaScriptNode rhs = TypeOfNode.create(this.getOperand());
            if (((Boolean)info[2]).booleanValue()) {
                JSConstantNode tmp = lhs;
                lhs = rhs;
                rhs = tmp;
            }
            JavaScriptNode materialized = (Boolean)info[1] != false ? JSIdenticalNode.createUnoptimized(lhs, rhs) : JSEqualNode.createUnoptimized(lhs, rhs);
            JSTypeofIdenticalNode.transferSourceSectionAddExpressionTag(this, lhs);
            JSTypeofIdenticalNode.transferSourceSectionAddExpressionTag(this, rhs);
            JSTypeofIdenticalNode.transferSourceSectionAndTags(this, materialized);
            return materialized;
        }
        return this;
    }

    private JavaScriptLanguage getLanguage() {
        return (JavaScriptLanguage)this.getRootNode().getLanguage(JavaScriptLanguage.class);
    }

    private Object[] parseMaterializationInfo() {
        boolean identity;
        String literal;
        boolean typeofAsLeftOperand;
        block9: {
            JSContext context = this.getLanguage().getJSContext();
            try {
                Expression expression = context.getEvaluator().parseExpression(context, this.getSourceSection().getCharacters().toString());
                if (expression instanceof BinaryNode) {
                    BinaryNode binaryNode = (BinaryNode)expression;
                    Expression lhs = binaryNode.getLhs();
                    Expression rhs = binaryNode.getRhs();
                    if (JSTypeofIdenticalNode.isTypeOf(lhs) && rhs instanceof LiteralNode) {
                        typeofAsLeftOperand = true;
                        literal = ((LiteralNode)rhs).getString();
                    } else if (JSTypeofIdenticalNode.isTypeOf(rhs) && lhs instanceof LiteralNode) {
                        typeofAsLeftOperand = false;
                        literal = ((LiteralNode)lhs).getString();
                    } else {
                        return null;
                    }
                    TokenType tokenType = binaryNode.tokenType();
                    if (tokenType == TokenType.EQ) {
                        identity = false;
                        break block9;
                    }
                    if (tokenType == TokenType.EQ_STRICT) {
                        identity = true;
                        break block9;
                    }
                    return null;
                }
                return null;
            }
            catch (ParserException ex) {
                return null;
            }
        }
        return new Object[]{literal, identity, typeofAsLeftOperand};
    }

    private static boolean isTypeOf(Expression expression) {
        return expression instanceof UnaryNode && ((UnaryNode)expression).tokenType() == TokenType.TYPEOF;
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public abstract boolean executeBoolean(VirtualFrame var1);

    @Specialization
    protected final boolean doBoolean(boolean value) {
        return this.type == Type.Boolean;
    }

    @Specialization
    protected final boolean doNumber(int value) {
        return this.type == Type.Number;
    }

    @Specialization
    protected final boolean doNumber(LargeInteger value) {
        return this.type == Type.Number;
    }

    @Specialization
    protected final boolean doNumber(long value) {
        return this.type == Type.Number;
    }

    @Specialization
    protected final boolean doNumber(double value) {
        return this.type == Type.Number;
    }

    @Specialization
    protected final boolean doSymbol(Symbol value) {
        return this.type == Type.Symbol;
    }

    @Specialization
    protected final boolean doBigInt(BigInt value) {
        return this.type == Type.BigInt;
    }

    @Specialization
    protected final boolean doString(CharSequence value) {
        return this.type == Type.String;
    }

    @Specialization(guards={"isJSType(value)"})
    protected final boolean doJSType(DynamicObject value, @Cached(value="create()") BranchProfile proxyBranch) {
        if (this.type == Type.Number || this.type == Type.BigInt || this.type == Type.String || this.type == Type.Boolean || this.type == Type.Symbol || this.type == Type.False) {
            return false;
        }
        if (this.type == Type.Object) {
            if (JSProxy.isProxy(value)) {
                proxyBranch.enter();
                return JSTypeofIdenticalNode.checkProxy(value, false);
            }
            return !JSFunction.isJSFunction(value) && value != Undefined.instance;
        }
        if (this.type == Type.Undefined) {
            return value == Undefined.instance;
        }
        if (this.type == Type.Function) {
            if (JSFunction.isJSFunction(value)) {
                return true;
            }
            if (JSProxy.isProxy(value)) {
                proxyBranch.enter();
                return JSTypeofIdenticalNode.checkProxy(value, true);
            }
            return false;
        }
        throw Errors.shouldNotReachHere();
    }

    @Specialization(guards={"isForeignObject(value)"}, limit="5")
    protected final boolean doForeignObject(TruffleObject value, @CachedLibrary(value="value") InteropLibrary interop) {
        if (this.type == Type.Undefined || this.type == Type.Symbol || this.type == Type.False) {
            return false;
        }
        if (this.type == Type.Boolean) {
            return interop.isBoolean((Object)value);
        }
        if (this.type == Type.String) {
            return interop.isString((Object)value);
        }
        if (this.type == Type.Number) {
            return interop.isNumber((Object)value);
        }
        if (this.type == Type.Function) {
            return interop.isExecutable((Object)value) || interop.isInstantiable((Object)value);
        }
        if (this.type == Type.Object) {
            return !interop.isExecutable((Object)value) && !interop.isInstantiable((Object)value) && !interop.isBoolean((Object)value) && !interop.isString((Object)value) && !interop.isNumber((Object)value);
        }
        return false;
    }

    private static boolean checkProxy(DynamicObject value, boolean isFunction) {
        TruffleObject obj = JSProxy.getTargetNonProxy(value);
        if (isFunction) {
            return JSFunction.isJSFunction(obj) || JSRuntime.isCallableForeign(obj) || JSRuntime.isConstructorForeign(obj);
        }
        return JSObject.isJSObject(obj) && !JSFunction.isJSFunction(obj) || JSRuntime.isForeignObject(obj) && !JSRuntime.isCallableForeign(obj) && !JSRuntime.isConstructorForeign(obj);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSTypeofIdenticalNodeGen.create(JSTypeofIdenticalNode.cloneUninitialized(this.getOperand()), this.type);
    }

    public static enum Type {
        Number,
        BigInt,
        String,
        Boolean,
        Object,
        Undefined,
        Function,
        Symbol,
        False;

    }
}

