/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import java.util.Collections;
import java.util.List;

public abstract class AbstractJSClass
extends JSClass {
    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object name) {
        throw Errors.createTypeErrorCannotGetProperty(name, thisObj, false, null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index) {
        throw Errors.createTypeErrorCannotGetProperty(String.valueOf(index), thisObj, false, null);
    }

    @Override
    public Object getMethodHelper(DynamicObject store, Object thisObj, Object key) {
        return this.getHelper(store, thisObj, key);
    }

    @Override
    public Object getHelper(DynamicObject store, Object thisObj, Object key) {
        return this.getOwnHelper(store, thisObj, key);
    }

    @Override
    public Object getHelper(DynamicObject store, Object thisObj, long index) {
        return this.getOwnHelper(store, thisObj, index);
    }

    @Override
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        throw Errors.createTypeErrorNotAnObject(thisObj);
    }

    @Override
    public boolean hasOwnProperty(DynamicObject thisObj, long index) {
        throw Errors.createTypeErrorNotAnObject(thisObj);
    }

    @Override
    public boolean hasProperty(DynamicObject thisObj, Object key) {
        return this.hasOwnProperty(thisObj, key);
    }

    @Override
    public boolean hasProperty(DynamicObject thisObj, long index) {
        return this.hasOwnProperty(thisObj, index);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setOwn(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        throw Errors.createTypeErrorCannotSetProperty(key, thisObj, null);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setOwn(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        throw Errors.createTypeErrorCannotSetProperty(String.valueOf(index), thisObj, null);
    }

    @Override
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        return this.setOwn(thisObj, key, value, receiver, isStrict);
    }

    @Override
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        return this.setOwn(thisObj, index, value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        throw Errors.createTypeErrorCannotDeletePropertyOf(key, thisObj);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        throw Errors.createTypeErrorCannotDeletePropertyOf(String.valueOf(index), thisObj);
    }

    @Override
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        return Collections.emptyList();
    }

    @Override
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        if (!this.setOwn(thisObj, key, desc.getValue(), (Object)thisObj, doThrow)) {
            if (this.isExtensible(thisObj)) {
                JSObjectUtil.putDataProperty(thisObj, key, desc, desc.getFlags());
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean preventExtensions(DynamicObject thisObj) {
        throw Errors.createTypeErrorNotAnObject(thisObj);
    }

    @Override
    public boolean isExtensible(DynamicObject thisObj) {
        throw Errors.createTypeErrorNotAnObject(thisObj);
    }

    @Override
    public boolean hasOnlyShapeProperties(DynamicObject obj) {
        return false;
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }

    @Override
    public boolean usesOrdinaryIsExtensible() {
        return false;
    }

    @Override
    public DynamicObject getPrototypeOf(DynamicObject thisObj) {
        return Null.instance;
    }

    @Override
    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        return true;
    }

    @Override
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        throw Errors.createTypeErrorNotAnObject(thisObj);
    }
}

