/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.js.runtime.joni.AbstractConstantKeysObject;
import com.oracle.truffle.js.runtime.joni.JoniCompiledRegexDispatchNode;
import com.oracle.truffle.js.runtime.joni.JoniCompiledRegexExecMethod;
import com.oracle.truffle.js.runtime.joni.JoniRegexFlags;
import com.oracle.truffle.js.runtime.joni.interop.ToLongNode;
import com.oracle.truffle.js.runtime.joni.interop.ToStringNode;
import com.oracle.truffle.js.runtime.joni.interop.TruffleNull;
import com.oracle.truffle.js.runtime.joni.interop.TruffleReadOnlyKeysArray;
import com.oracle.truffle.js.runtime.joni.result.JoniNoMatchResult;
import com.oracle.truffle.regex.nashorn.regexp.joni.Regex;

@ExportLibrary(value=InteropLibrary.class)
public class JoniCompiledRegex
extends AbstractConstantKeysObject {
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("exec", "pattern", "flags", "groupCount", "groups");
    private final String pattern;
    private final JoniRegexFlags flags;
    private final Regex joniRegex;
    private final CallTarget regexCallTarget;

    public JoniCompiledRegex(String pattern, JoniRegexFlags flags, Regex joniRegex, CallTarget regexCallTarget) {
        this.pattern = pattern;
        this.flags = flags;
        this.joniRegex = joniRegex;
        this.regexCallTarget = regexCallTarget;
    }

    public Regex getJoniRegex() {
        return this.joniRegex;
    }

    public CallTarget getRegexCallTarget() {
        return this.regexCallTarget;
    }

    public JoniCompiledRegexExecMethod getExecMethod() {
        return new JoniCompiledRegexExecMethod(this);
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "exec": {
                return this.getExecMethod();
            }
            case "pattern": {
                return this.pattern;
            }
            case "flags": {
                return this.flags;
            }
            case "groupCount": {
                return this.joniRegex.numberOfCaptures() + 1;
            }
            case "groups": {
                return TruffleNull.getInstance();
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw UnknownIdentifierException.create((String)symbol);
    }

    @ExportMessage
    boolean isMemberInvocable(String member) {
        return "exec".equals(member);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached(value="create()") ToStringNode toStringNode, @Cached ToLongNode toLongNode, @Cached JoniCompiledRegexDispatchNode executeNode) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
        if (!"exec".equals(member)) {
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.create();
        }
        if (args.length != 2) {
            CompilerDirectives.transferToInterpreter();
            throw ArityException.create((int)2, (int)args.length);
        }
        String input = toStringNode.execute(args[0]);
        long fromIndex = toLongNode.execute(args[1]);
        if (fromIndex > Integer.MAX_VALUE) {
            return JoniNoMatchResult.getInstance();
        }
        return executeNode.execute(this, input, (int)fromIndex);
    }
}

