/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.result.LazyResult;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;

public final class LazyCaptureGroupsResult
extends LazyResult
implements JsonConvertible {
    private int[] result = null;
    private final CallTarget findStartCallTarget;
    private final CallTarget captureGroupCallTarget;

    public LazyCaptureGroupsResult(Object input, int fromIndex, int end, CallTarget findStartCallTarget, CallTarget captureGroupCallTarget) {
        super(input, fromIndex, end);
        this.findStartCallTarget = findStartCallTarget;
        this.captureGroupCallTarget = captureGroupCallTarget;
    }

    public LazyCaptureGroupsResult(Object input, int[] result) {
        this(input, -1, -1, null, null);
        this.result = result;
    }

    @Override
    public int getStart(int groupNumber) {
        return this.result[groupNumber * 2] - 1;
    }

    @Override
    public int getEnd(int groupNumber) {
        return this.result[groupNumber * 2 + 1] - 1;
    }

    public void setResult(int[] result) {
        this.result = result;
    }

    public int[] getResult() {
        return this.result;
    }

    public CallTarget getFindStartCallTarget() {
        return this.findStartCallTarget;
    }

    public CallTarget getCaptureGroupCallTarget() {
        return this.captureGroupCallTarget;
    }

    public Object[] createArgsFindStart() {
        return new Object[]{this.getInput(), this.getEnd() - 1, this.getFromIndex()};
    }

    public Object[] createArgsCG(int start) {
        return new Object[]{this, start + 1, this.getEnd()};
    }

    public Object[] createArgsCGNoFindStart() {
        assert (this.findStartCallTarget == null);
        return new Object[]{this, this.getFromIndex(), this.getEnd()};
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void debugForceEvaluation() {
        if (this.result == null) {
            if (this.getFindStartCallTarget() == null) {
                this.getCaptureGroupCallTarget().call(this.createArgsCGNoFindStart());
            } else {
                this.getCaptureGroupCallTarget().call(this.createArgsCG((Integer)this.getFindStartCallTarget().call(this.createArgsFindStart())));
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this.result == null) {
            this.debugForceEvaluation();
        }
        StringBuilder sb = new StringBuilder("[").append(this.result[0] - 1);
        for (int i = 1; i < this.result.length; ++i) {
            sb.append(", ").append(this.result[i] - 1);
        }
        return sb.append("]").toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonObject toJson() {
        return super.toJson().append(Json.prop("result", Json.array(this.result)));
    }
}

